/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collections;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public final class NodeEncoderStep
extends ExecutorServiceStep<Batch<InputNode, NodeRecord>> {
    private final IdMapper idMapper;
    private final IdGenerator idGenerator;
    private final NodeStore nodeStore;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelHolder;

    public NodeEncoderStep(StageControl control, Configuration config, IdMapper idMapper, IdGenerator idGenerator, BatchingTokenRepository.BatchingLabelTokenRepository labelHolder, NodeStore nodeStore, StatsProvider memoryUsageStats) {
        super(control, "NODE", config.workAheadSize(), config.movingAverageSize(), 1, memoryUsageStats);
        this.idMapper = idMapper;
        this.idGenerator = idGenerator;
        this.nodeStore = nodeStore;
        this.labelHolder = labelHolder;
    }

    @Override
    protected Object process(long ticket, Batch<InputNode, NodeRecord> batch) {
        InputNode[] input = (InputNode[])batch.input;
        batch.records = new NodeRecord[input.length];
        for (int i = 0; i < input.length; ++i) {
            InputNode batchNode = input[i];
            long nodeId = this.idGenerator.generate(batchNode.id());
            if (batchNode.id() != null) {
                this.idMapper.put(batchNode.id(), nodeId, batchNode.group());
            }
            NodeRecord nodeRecord = new NodeRecord(nodeId, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            ((NodeRecord[])batch.records)[i] = nodeRecord;
            NodeRecord nodeRecord2 = nodeRecord;
            nodeRecord2.setInUse(true);
            if (batchNode.hasLabelField()) {
                nodeRecord2.setLabelField(batchNode.labelField(), Collections.emptyList());
                continue;
            }
            long[] labels = this.labelHolder.getOrCreateIds(batchNode.labels());
            InlineNodeLabels.putSorted(nodeRecord2, labels, null, this.nodeStore.getDynamicLabelStore());
        }
        return batch;
    }
}

