/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.net.URL;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.RestartOnChange;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.MonitoredRollingPolicy;
import org.neo4j.kernel.logging.Slf4jMarkerAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LogbackService
extends LifecycleAdapter
implements Logging {
    private final Config config;
    private final LoggerContext loggerContext;
    private final LifeSupport loggingLife = new LifeSupport();
    protected RestartOnChange restartOnChange;

    public LogbackService(Config config, LoggerContext loggerContext) {
        this(config, loggerContext, "neo4j-logback.xml", new Monitors());
    }

    public LogbackService(final Config config, final LoggerContext loggerContext, final String logbackConfigurationFilename, Monitors monitors) {
        this.config = config;
        this.loggerContext = loggerContext;
        MonitoredRollingPolicy.setMonitorsInstance(monitors);
        final File storeDir = config.get(GraphDatabaseSettings.store_dir);
        if (storeDir != null) {
            File file = storeDir.getAbsoluteFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            this.loggingLife.add(new LifecycleAdapter(){

                @Override
                public void start() throws Throwable {
                    JoranConfigurator configurator = new JoranConfigurator();
                    configurator.setContext((Context)loggerContext);
                    if (config.getParams().containsKey("ha.server_id")) {
                        loggerContext.putProperty("host", config.getParams().get("ha.server_id"));
                    }
                    loggerContext.putProperty("neo_store", storeDir.getPath());
                    loggerContext.putProperty("remote_logging_enabled", config.get(GraphDatabaseSettings.remote_logging_enabled).toString());
                    loggerContext.putProperty("remote_logging_host", config.get(GraphDatabaseSettings.remote_logging_host));
                    loggerContext.putProperty("remote_logging_port", config.get(GraphDatabaseSettings.remote_logging_port).toString());
                    try {
                        URL resource = this.getClass().getClassLoader().getResource(logbackConfigurationFilename);
                        if (resource == null) {
                            throw new IllegalStateException(String.format("Could not find %s configuration", logbackConfigurationFilename));
                        }
                        configurator.doConfigure(resource);
                    }
                    catch (JoranException e) {
                        throw new IllegalStateException("Failed to configure logging", e);
                    }
                }

                @Override
                public void stop() throws Throwable {
                    loggerContext.getLogger("org.neo4j").detachAndStopAllAppenders();
                }
            });
            this.loggingLife.start();
            MonitoredRollingPolicy.setMonitorsInstance(null);
            this.restartOnChange = new RestartOnChange("remote_logging_", (Lifecycle)this.loggingLife);
            config.addConfigurationChangeListener(this.restartOnChange);
        }
    }

    @Override
    public void shutdown() throws Throwable {
        this.loggingLife.shutdown();
        if (this.restartOnChange != null) {
            this.config.removeConfigurationChangeListener(this.restartOnChange);
        }
    }

    @Override
    public StringLogger getMessagesLog(Class loggingClass) {
        return new Slf4jToStringLoggerAdapter((Logger)this.loggerContext.getLogger(loggingClass));
    }

    @Override
    public ConsoleLogger getConsoleLog(Class loggingClass) {
        return new ConsoleLogger(new Slf4jToStringLoggerAdapter((Logger)this.loggerContext.getLogger(loggingClass)));
    }

    private static class Slf4jToStringLoggerAdapter
    extends StringLogger {
        private final Logger logger;
        private final boolean debugEnabled;

        public Slf4jToStringLoggerAdapter(Logger logger) {
            this.logger = logger;
            this.debugEnabled = logger.isDebugEnabled();
        }

        @Override
        protected void logLine(String line) {
            this.logger.info(line);
        }

        @Override
        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, final boolean flush) {
            this.logMessage(msg, flush);
            source.visit(new StringLogger.LineLogger(){

                @Override
                public void logLine(String line) {
                    Slf4jToStringLoggerAdapter.this.logMessage(line, flush);
                }
            });
        }

        @Override
        public void logMessage(String msg, boolean flush) {
            if (this.isDebugEnabled()) {
                this.logger.debug(msg);
            } else {
                this.logger.info(msg);
            }
        }

        @Override
        public void logMessage(String msg, LogMarker marker) {
            this.logger.info(Slf4jToStringLoggerAdapter.from(marker), msg);
        }

        @Override
        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.logger.error(msg, cause);
        }

        @Override
        public void debug(String msg) {
            if (this.isDebugEnabled()) {
                this.logger.debug(msg);
            }
        }

        @Override
        public void debug(String msg, Throwable cause) {
            this.logger.debug(msg, cause);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void info(String msg, Throwable cause) {
            this.logger.info(msg, cause);
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String msg, Throwable throwable) {
            this.logger.warn(msg, throwable);
        }

        @Override
        public void error(String msg) {
            this.logger.error(msg);
        }

        @Override
        public void error(String msg, Throwable throwable) {
            this.logger.error(msg, throwable);
        }

        @Override
        public void addRotationListener(Runnable listener) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        private static Marker from(LogMarker marker) {
            return new Slf4jMarkerAdapter(marker.getName());
        }
    }
}

