/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.SchemaRule;

public class IntegrityValidator {
    private final NeoStore neoStore;
    private final IndexingService indexes;

    public IntegrityValidator(NeoStore neoStore, IndexingService indexes) {
        this.neoStore = neoStore;
        this.indexes = indexes;
    }

    public void validateNodeRecord(NodeRecord record) throws TransactionFailureException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, "Node record " + record + " still has relationships", new Object[0]);
        }
    }

    public void validateTransactionStartKnowledge(long lastCommittedTxWhenTransactionStarted) throws TransactionFailureException {
        long latestConstraintIntroducingTx = this.neoStore.getLatestConstraintIntroducingTx();
        if (lastCommittedTxWhenTransactionStarted < latestConstraintIntroducingTx) {
            throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, "Database constraints have changed (txId=%d) after this transaction (txId=%d) started, which is not yet supported. Please retry your transaction to ensure all constraints are executed.", latestConstraintIntroducingTx, lastCommittedTxWhenTransactionStarted);
        }
    }

    public void validateSchemaRule(SchemaRule schemaRule) throws TransactionFailureException {
        if (schemaRule instanceof UniquenessConstraintRule) {
            try {
                this.indexes.validateIndex(((UniquenessConstraintRule)schemaRule).getOwnedIndex());
            }
            catch (ConstraintVerificationFailedKernelException e) {
                throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, (Throwable)e, "Index valiation failed", new Object[0]);
            }
            catch (IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, (Throwable)e, "Index population failure", new Object[0]);
            }
        }
    }
}

