/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.NeoStoreFormatUtils;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.standard.BaseRecordCursor;
import org.neo4j.kernel.impl.store.standard.FixedSizeRecordStoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;

public class RelationshipGroupStoreFormat_v2_2
extends FixedSizeRecordStoreFormat<RelationshipGroupRecord, RelationshipGroupRecordCursor> {
    private final RelationshipGroupRecordFormat recordFormat = new RelationshipGroupRecordFormat();

    public RelationshipGroupStoreFormat_v2_2() {
        super(25, "RelationshipStore", "v0.A.5");
    }

    @Override
    public RelationshipGroupRecordCursor createCursor(PagedFile file, StoreToolkit toolkit, int flags) {
        return new RelationshipGroupRecordCursor(file, toolkit, this.recordFormat, flags);
    }

    @Override
    public StoreFormat.RecordFormat<RelationshipGroupRecord> recordFormat() {
        return this.recordFormat;
    }

    public static class RelationshipGroupRecordCursor
    extends BaseRecordCursor<RelationshipGroupRecord, RelationshipGroupRecordFormat> {
        public RelationshipGroupRecordCursor(PagedFile file, StoreToolkit toolkit, RelationshipGroupRecordFormat format, int flags) {
            super(file, toolkit, format, flags);
        }
    }

    public static class RelationshipGroupRecordFormat
    implements StoreFormat.RecordFormat<RelationshipGroupRecord> {
        private static final int IN_USE = 0;
        private static final int HIGH_BYTE = 1;
        private static final int TYPE = 2;
        private static final int NEXT_LOW_BITS = 4;
        private static final int NEXT_OUT_LOW_BITS = 8;
        private static final int NEXT_IN_LOW_BITS = 12;
        private static final int NEXT_LOOP_LOW_BITS = 16;
        private static final int OWNER_LOW_BITS = 20;
        private static final int OWNER_HIGH_BITS = 24;
        private static final int RECORD_SIZE = 25;

        @Override
        public String recordName() {
            return "RelationshipGroupRecord";
        }

        @Override
        public long id(RelationshipGroupRecord record) {
            return record.getId();
        }

        @Override
        public RelationshipGroupRecord newRecord(long id) {
            return new RelationshipGroupRecord(id, -1);
        }

        @Override
        public void serialize(PageCursor cursor, int offset, RelationshipGroupRecord record) {
            if (record.inUse()) {
                long nextMod = record.getNext() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getNext() & 0x700000000L) >> 31;
                long nextOutMod = record.getFirstOut() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstOut() & 0x700000000L) >> 28;
                long nextInMod = record.getFirstIn() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstIn() & 0x700000000L) >> 31;
                long nextLoopMod = record.getFirstLoop() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstLoop() & 0x700000000L) >> 28;
                cursor.putByte(offset + 0, (byte)(nextOutMod | nextMod | 1L));
                cursor.putByte(offset + 1, (byte)(nextLoopMod | nextInMod));
                cursor.putShort(offset + 2, (short)record.getType());
                cursor.putInt(offset + 4, (int)record.getNext());
                cursor.putInt(offset + 8, (int)record.getFirstOut());
                cursor.putInt(offset + 12, (int)record.getFirstIn());
                cursor.putInt(offset + 16, (int)record.getFirstLoop());
                cursor.putInt(offset + 20, (int)record.getOwningNode());
                cursor.putByte(offset + 24, (byte)(record.getOwningNode() >> 32));
            } else {
                cursor.putByte(offset + 0, (byte)0);
            }
        }

        @Override
        public void deserialize(PageCursor cursor, int offset, long id, RelationshipGroupRecord record) {
            long inUseByte = cursor.getByte(offset + 0);
            long highByte = cursor.getByte(offset + 1);
            short type = cursor.getShort(offset + 2);
            long nextLowBits = cursor.getUnsignedInt(offset + 4);
            long nextOutLowBits = cursor.getUnsignedInt(offset + 8);
            long nextInLowBits = cursor.getUnsignedInt(offset + 12);
            long nextLoopLowBits = cursor.getUnsignedInt(offset + 16);
            long ownerLowBits = cursor.getUnsignedInt(offset + 20);
            byte ownerHighBits = cursor.getByte(offset + 24);
            record.setId(id);
            record.setType(type);
            record.setInUse((inUseByte & 1L) > 0L);
            record.setNext(NeoStoreFormatUtils.longFromIntAndMod(nextLowBits, (inUseByte & 0xEL) << 31));
            record.setFirstOut(NeoStoreFormatUtils.longFromIntAndMod(nextOutLowBits, (inUseByte & 0x70L) << 28));
            record.setFirstIn(NeoStoreFormatUtils.longFromIntAndMod(nextInLowBits, (highByte & 0xEL) << 31));
            record.setFirstLoop(NeoStoreFormatUtils.longFromIntAndMod(nextLoopLowBits, (highByte & 0x70L) << 28));
            record.setOwningNode(ownerLowBits | (long)ownerHighBits << 32);
        }

        @Override
        public boolean inUse(PageCursor cursor, int offset) {
            return (cursor.getByte(offset + 0) & 1) == 1;
        }
    }
}

