/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.QuantizedProjection;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class SpectrumExecutionMonitor
extends AbstractExecutionMonitor {
    public static final int DEFAULT_WIDTH = 100;
    private static final char[] WEIGHTS = new char[]{' ', 'k', 'M', 'B', 'T'};
    private final PrintStream out;
    private final int width;

    public SpectrumExecutionMonitor(long interval, TimeUnit unit, PrintStream out, int width) {
        super(interval, unit);
        this.out = out;
        this.width = width;
    }

    @Override
    public void start(StageExecution[] executions) {
        for (int i = 0; i < executions.length; ++i) {
            if (i > 0) {
                this.out.print(", ");
            }
            this.out.print(executions[i].getStageName());
        }
        this.out.println();
    }

    @Override
    public void end(StageExecution[] executions, long totalTimeMillis) {
        this.check(executions);
        this.out.println();
        this.out.println("Done in " + Format.duration(totalTimeMillis));
    }

    @Override
    public void done(long totalTimeMillis) {
        this.out.println();
        this.out.println("IMPORT DONE in " + Format.duration(totalTimeMillis));
    }

    @Override
    public void check(StageExecution[] executions) {
        float partWidth = (float)this.width / (float)executions.length;
        StringBuilder builder = new StringBuilder();
        boolean allPrinted = true;
        for (StageExecution execution : executions) {
            allPrinted &= this.printSpectrum(builder, execution, Math.round(partWidth));
        }
        if (allPrinted) {
            this.out.print("\r" + builder);
        }
    }

    private boolean printSpectrum(StringBuilder builder, StageExecution execution, int width) {
        Step<?> step;
        StepStats stats;
        long[] values = this.values(execution);
        long total = this.total(values);
        if (total == 0L) {
            return false;
        }
        Pair<Step<?>, Float> bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next();
        QuantizedProjection projection = new QuantizedProjection(total, width -= values.length + 1 + 4);
        long lastDoneBatches = 0L;
        int stepIndex = 0;
        Iterator<Step<?>> i$ = execution.steps().iterator();
        while (i$.hasNext() && projection.next(this.avg(stats = (step = i$.next()).stats()))) {
            long stepWidth = projection.step();
            boolean isBottleNeck = bottleNeck.first() == step;
            String name = (isBottleNeck ? "*" : "") + stats.toString(DetailLevel.IMPORTANT) + (step.numberOfProcessors() > 1 ? "(" + step.numberOfProcessors() + ")" : "");
            builder.append(stepIndex++ == 0 ? (char)'[' : '|');
            int charIndex = 0;
            char backgroundChar = step.numberOfProcessors() > 1 ? (char)'=' : '-';
            int i = 0;
            while ((long)i < stepWidth) {
                char ch = backgroundChar;
                if (charIndex >= 0 && charIndex < name.length() && (long)charIndex < stepWidth) {
                    ch = name.charAt(charIndex);
                }
                builder.append(ch);
                ++i;
                ++charIndex;
            }
            lastDoneBatches = stats.stat(Keys.done_batches).asLong();
        }
        long progress = lastDoneBatches * (long)execution.getConfig().batchSize();
        builder.append("]").append(SpectrumExecutionMonitor.fitInFour(progress));
        return true;
    }

    private static String fitInFour(long value) {
        int weight = SpectrumExecutionMonitor.weight(value);
        String result = weight == 0 ? String.valueOf(value) : String.format("%d%s", (long)((double)value / Math.pow(1000.0, weight)), Character.valueOf(WEIGHTS[weight]));
        return SpectrumExecutionMonitor.pad(result, 4, ' ');
    }

    private static String pad(String result, int length, char padChar) {
        while (result.length() < length) {
            result = padChar + result;
        }
        return result;
    }

    private static int weight(long value) {
        int weight = 0;
        while (value >= 1000L) {
            value /= 1000L;
            ++weight;
        }
        return weight;
    }

    private long[] values(StageExecution execution) {
        long[] values = new long[execution.size()];
        int i = 0;
        for (Step<?> step : execution.steps()) {
            values[i++] = this.avg(step.stats());
        }
        return values;
    }

    private long total(long[] values) {
        long total = 0L;
        for (long value : values) {
            total += value;
        }
        return total;
    }

    private long avg(StatsProvider step) {
        return step.stat(Keys.avg_processing_time).asLong();
    }
}

