/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.function.Function;
import org.neo4j.unsafe.impl.batchimport.input.DataException;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

class InputRelationshipDeserializer
extends InputEntityDeserializer<InputRelationship> {
    private String type;
    private Object startNode;
    private Object endNode;
    private final Group startNodeGroup;
    private final Group endNodeGroup;

    InputRelationshipDeserializer(Header header, CharSeeker data, int delimiter, Function<InputRelationship, InputRelationship> decorator, Groups groups) {
        super(header, data, delimiter, decorator);
        this.startNodeGroup = groups.getOrCreate(header.entry(Type.START_ID).groupName());
        this.endNodeGroup = groups.getOrCreate(header.entry(Type.END_ID).groupName());
    }

    @Override
    protected void handleValue(Header.Entry entry, Object value) {
        switch (entry.type()) {
            case TYPE: {
                this.type = (String)value;
                break;
            }
            case START_ID: {
                this.startNode = value;
                break;
            }
            case END_ID: {
                this.endNode = value;
            }
        }
    }

    @Override
    protected InputRelationship convertToInputEntity(Object[] properties) {
        return new InputRelationship(properties, null, this.startNodeGroup, this.startNode, this.endNodeGroup, this.endNode, this.type, null);
    }

    @Override
    protected void validate(InputRelationship entity) {
        if (!entity.hasTypeId() && entity.type() == null) {
            throw new DataException(entity + " is missing " + (Object)((Object)Type.TYPE) + " field");
        }
    }
}

