/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.UnexpectedEndOfInputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;

abstract class InputEntityDeserializer<ENTITY extends InputEntity>
extends PrefetchingIterator<ENTITY>
implements InputIterator<ENTITY> {
    protected final Header header;
    private final CharSeeker data;
    private final Mark mark = new Mark();
    private final int delimiter;
    private final Function<ENTITY, ENTITY> decorator;
    private Object[] properties = new Object[20];
    private int propertiesCursor;

    InputEntityDeserializer(Header header, CharSeeker data, int delimiter, Function<ENTITY, ENTITY> decorator) {
        this.header = header;
        this.data = data;
        this.delimiter = delimiter;
        this.decorator = decorator;
    }

    @Override
    protected ENTITY fetchNextOrNull() {
        int fieldIndex;
        Header.Entry[] entries = this.header.entries();
        try {
            Object value;
            for (fieldIndex = 0; fieldIndex < entries.length; ++fieldIndex) {
                if (!this.data.seek(this.mark, this.delimiter)) {
                    if (fieldIndex > 0) {
                        throw new UnexpectedEndOfInputException("Near " + this.mark);
                    }
                    ENTITY ENTITY = null;
                    return ENTITY;
                }
                Header.Entry entry = entries[fieldIndex];
                value = this.data.tryExtract(this.mark, entry.extractor()) ? entry.extractor().value() : null;
                boolean handled = true;
                switch (entry.type()) {
                    case PROPERTY: {
                        this.addProperty(entry, value);
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                    default: {
                        handled = false;
                    }
                }
                if (!handled) {
                    this.handleValue(entry, value);
                }
                if (this.mark.isEndOfLine()) break;
            }
            Object entity = this.convertToInputEntity(this.properties());
            while (!this.mark.isEndOfLine()) {
                this.data.seek(this.mark, this.delimiter);
            }
            entity = (InputEntity)this.decorator.apply(entity);
            this.validate(entity);
            value = entity;
            return value;
        }
        catch (IOException e) {
            throw new InputException("Unable to read more data from input stream", e);
        }
        catch (RuntimeException e) {
            String stringValue = null;
            try {
                Extractors extractors = new Extractors('?');
                if (this.data.tryExtract(this.mark, extractors.string())) {
                    stringValue = (String)extractors.string().value();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            String message = String.format("ERROR in input%n  data source: %s%n  in field: %s%n  for header: %s%n  raw field value: %s%n  original error: %s", this.data, entries[fieldIndex] + ":" + (fieldIndex + 1), this.header, stringValue != null ? stringValue : "??", e.getMessage());
            if (e instanceof InputException) {
                throw Exceptions.withMessage(e, message);
            }
            throw new InputException(message, e);
        }
        finally {
            this.propertiesCursor = 0;
        }
    }

    protected void validate(ENTITY entity) {
    }

    protected void addProperty(Header.Entry entry, Object value) {
        if (value != null) {
            this.ensurePropertiesArrayCapacity(this.propertiesCursor + 2);
            this.properties[this.propertiesCursor++] = entry.name();
            this.properties[this.propertiesCursor++] = value;
        }
    }

    private Object[] properties() {
        return this.propertiesCursor > 0 ? Arrays.copyOf(this.properties, this.propertiesCursor) : InputEntity.NO_PROPERTIES;
    }

    private void ensurePropertiesArrayCapacity(int length) {
        if (length > this.properties.length) {
            this.properties = Arrays.copyOf(this.properties, length);
        }
    }

    @Override
    public void close() {
        try {
            this.data.close();
        }
        catch (IOException e) {
            throw new InputException("Unable to close data iterator", e);
        }
    }

    protected abstract ENTITY convertToInputEntity(Object[] var1);

    protected abstract void handleValue(Header.Entry var1, Object var2);

    @Override
    public long position() {
        return this.data.position();
    }

    public String toString() {
        return this.data.toString();
    }
}

