/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.File;
import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

public class Inputs {
    public static Input input(Iterable<InputNode> nodes, Iterable<InputRelationship> relationships, final IdMapper idMapper, final IdGenerator idGenerator, final boolean specificRelationshipIds) {
        final InputIterable<InputNode> resourceNodes = Inputs.asInputIterable(nodes);
        final InputIterable<InputRelationship> resourceRelationships = Inputs.asInputIterable(relationships);
        return new Input(){

            @Override
            public InputIterable<InputRelationship> relationships() {
                return resourceRelationships;
            }

            @Override
            public InputIterable<InputNode> nodes() {
                return resourceNodes;
            }

            @Override
            public IdMapper idMapper() {
                return idMapper;
            }

            @Override
            public IdGenerator idGenerator() {
                return idGenerator;
            }

            @Override
            public boolean specificRelationshipIds() {
                return specificRelationshipIds;
            }
        };
    }

    public static Input csv(File nodes, File relationships, IdType idType, Configuration configuration) {
        return new CsvInput(DataFactories.nodeData(DataFactories.data(InputEntityDecorators.NO_NODE_DECORATOR, nodes)), DataFactories.defaultFormatNodeFileHeader(), DataFactories.relationshipData(DataFactories.data(InputEntityDecorators.NO_RELATIONSHIP_DECORATOR, relationships)), DataFactories.defaultFormatRelationshipFileHeader(), idType, configuration);
    }

    public static <T> InputIterable<T> asInputIterable(final Iterable<T> iterable) {
        return new InputIterable<T>(){

            @Override
            public InputIterator<T> iterator() {
                return new PlainInputIterator(iterable.iterator());
            }
        };
    }

    private static class PlainInputIterator<T>
    extends IteratorWrapper<T, T>
    implements InputIterator<T> {
        public PlainInputIterator(Iterator<T> iteratorToWrap) {
            super(iteratorToWrap);
        }

        @Override
        protected T underlyingObjectToObject(T object) {
            return object;
        }

        @Override
        public void close() {
        }

        @Override
        public long position() {
            return 0L;
        }
    }
}

