/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public interface AvailableMemoryCalculator {
    public static final AvailableMemoryCalculator RUNTIME = new AvailableMemoryCalculator(){

        @Override
        public long availableOffHeapMemory() {
            return this.osBean().getFreePhysicalMemorySize();
        }

        private OperatingSystemMXBean osBean() {
            OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return bean;
        }

        @Override
        public long availableHeapMemory() {
            Runtime runtime = this.runtime();
            return runtime.maxMemory() - runtime.totalMemory();
        }

        private Runtime runtime() {
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            return runtime;
        }

        public String toString() {
            return "Java runtime memory calculator";
        }
    };

    public long availableHeapMemory();

    public long availableOffHeapMemory();
}

