/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.StoreProcessor;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class StoreProcessorStep<RECORD extends AbstractBaseRecord>
extends LonelyProcessingStep
implements StatsProvider {
    private final RecordStore<RECORD> store;
    private final StoreProcessor<RECORD> processor;
    private final int recordSize;
    private long id;
    private long highestId;

    public StoreProcessorStep(StageControl control, String name, int batchSize, int movingAverageSize, RecordStore<RECORD> store, StoreProcessor<RECORD> processor) {
        super(control, name, batchSize, movingAverageSize);
        this.store = store;
        this.processor = processor;
        this.recordSize = store.getRecordSize();
    }

    @Override
    protected void process() {
        this.highestId = this.store.getHighestPossibleIdInUse();
        RECORD heavilyReusedRecord = this.createReusableRecord();
        this.id = this.highestId;
        while (this.id >= 0L) {
            RECORD record = this.loadRecord(this.id, heavilyReusedRecord);
            if (record != null && this.processor.process(record)) {
                this.store.updateRecord(heavilyReusedRecord);
            }
            this.itemProcessed();
            --this.id;
        }
        this.processor.done();
    }

    @Override
    protected void addStatsProviders(Collection<StatsProvider> providers) {
        super.addStatsProviders(providers);
        providers.add(this);
    }

    @Override
    public Stat stat(Key key) {
        if (key == Keys.io_throughput) {
            return new IoThroughputStat(this.startTime, this.endTime, (long)this.recordSize * (this.highestId - this.id));
        }
        return null;
    }

    @Override
    public Key[] keys() {
        return new Key[]{Keys.io_throughput};
    }

    protected abstract RECORD loadRecord(long var1, RECORD var3);

    protected abstract RECORD createReusableRecord();
}

