/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipPreparationStep
extends ExecutorServiceStep<Batch<InputRelationship, RelationshipRecord>> {
    private final IdMapper idMapper;

    public RelationshipPreparationStep(StageControl control, Configuration config, IdMapper idMapper) {
        super(control, "PREPARE", config.workAheadSize(), config.movingAverageSize(), 1, true);
        this.idMapper = idMapper;
    }

    @Override
    protected Object process(long ticket, Batch<InputRelationship, RelationshipRecord> batch) {
        InputRelationship[] input = (InputRelationship[])batch.input;
        batch.ids = new long[input.length * 2];
        long[] ids = batch.ids;
        for (int i = 0; i < input.length; ++i) {
            InputRelationship batchRelationship = input[i];
            ids[i * 2] = this.idMapper.get(batchRelationship.startNode(), batchRelationship.startNodeGroup());
            ids[i * 2 + 1] = this.idMapper.get(batchRelationship.endNode(), batchRelationship.endNodeGroup());
        }
        return batch;
    }
}

