/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class CalculateDenseNodesStep
extends ExecutorServiceStep<Batch<InputRelationship, RelationshipRecord>> {
    private final NodeRelationshipLink nodeRelationshipLink;
    private long highestSeenNodeId;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipLink nodeRelationshipLink) {
        super(control, "CALCULATOR", config.workAheadSize(), config.movingAverageSize(), 1);
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected Object process(long ticket, Batch<InputRelationship, RelationshipRecord> batch) {
        InputRelationship[] input = (InputRelationship[])batch.input;
        long[] ids = batch.ids;
        for (int i = 0; i < input.length; ++i) {
            InputRelationship rel = input[i];
            long startNode = ids[i * 2];
            long endNode = ids[i * 2 + 1];
            this.ensureNodeFound("start", rel, startNode);
            this.ensureNodeFound("end", rel, endNode);
            try {
                this.nodeRelationshipLink.incrementCount(startNode);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("Input relationship " + rel + " refers to missing start node " + rel.startNode(), e);
            }
            if (!rel.isLoop()) {
                try {
                    this.nodeRelationshipLink.incrementCount(endNode);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Input relationship " + rel + " refers to missing end node " + rel.endNode(), e);
                }
            }
            this.highestSeenNodeId = Math.max(this.highestSeenNodeId, Math.max(startNode, endNode));
        }
        return null;
    }

    private void ensureNodeFound(String nodeDescription, InputRelationship relationship, long actualNodeId) {
        if (actualNodeId == -1L) {
            throw new InputException(relationship + " specified " + nodeDescription + " node that hasn't been imported");
        }
    }
}

