/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;

public class ControlledLoaders {
    private final ControlledLoader<Long, NodeRecord, Void> nodes = new ControlledLoader();
    private final ControlledLoader<Long, PropertyRecord, PrimitiveRecord> properties = new ControlledLoader();
    private final ControlledLoader<Long, RelationshipRecord, Void> relationships = new ControlledLoader();
    private final ControlledLoader<Long, RelationshipGroupRecord, Integer> relationshipGroups = new ControlledLoader();
    private final ControlledLoader<Long, Collection<DynamicRecord>, SchemaRule> schemaRules = new ControlledLoader();
    private final ControlledLoader<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokens = new ControlledLoader();
    private final ControlledLoader<Integer, LabelTokenRecord, Void> labelTokens = new ControlledLoader();
    private final ControlledLoader<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokens = new ControlledLoader();

    public Map<Long, NodeRecord> getNodes() {
        return ((ControlledLoader)this.nodes).data;
    }

    public Map<Long, PropertyRecord> getProperties() {
        return ((ControlledLoader)this.properties).data;
    }

    public Map<Long, RelationshipRecord> getRelationships() {
        return ((ControlledLoader)this.relationships).data;
    }

    public Map<Long, RelationshipGroupRecord> getRelationshipGroups() {
        return ((ControlledLoader)this.relationshipGroups).data;
    }

    public Map<Long, Collection<DynamicRecord>> getSchemaRules() {
        return ((ControlledLoader)this.schemaRules).data;
    }

    public Map<Integer, PropertyKeyTokenRecord> getPropertyKeyTokens() {
        return ((ControlledLoader)this.propertyKeyTokens).data;
    }

    public Map<Integer, LabelTokenRecord> getLabelTokens() {
        return ((ControlledLoader)this.labelTokens).data;
    }

    public Map<Integer, RelationshipTypeTokenRecord> getRelationshipTypeTokens() {
        return ((ControlledLoader)this.relationshipTypeTokens).data;
    }

    public RecordAccessSet newAccessSet() {
        return new RecordChangeSet(this.nodes, this.properties, this.relationships, this.relationshipGroups, this.schemaRules, this.propertyKeyTokens, this.labelTokens, this.relationshipTypeTokens);
    }

    private static class ControlledLoader<KEY, RECORD, ADDITIONAL>
    implements RecordAccess.Loader<KEY, RECORD, ADDITIONAL> {
        private final Map<KEY, RECORD> data = new HashMap<KEY, RECORD>();

        private ControlledLoader() {
        }

        @Override
        public RECORD newUnused(KEY key, ADDITIONAL additionalData) {
            throw new UnsupportedOperationException("Please implement");
        }

        @Override
        public RECORD load(KEY key, ADDITIONAL additionalData) {
            return this.data.get(key);
        }

        @Override
        public void ensureHeavy(RECORD record) {
        }

        @Override
        public RECORD clone(RECORD record) {
            throw new UnsupportedOperationException("Please implement");
        }
    }
}

