/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Arrays;
import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.transaction.command.LogHandler;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;

public class LogEntryStart
extends AbstractLogEntry {
    public static final byte[] EMPTY_ADDITIONAL_ARRAY = new byte[0];
    private final int masterId;
    private final int authorId;
    private final long timeWritten;
    private final long lastCommittedTxWhenTransactionStarted;
    private final byte[] additionalHeader;
    private LogPosition startPosition;

    public LogEntryStart(int masterId, int authorId, long timeWritten, long lastCommittedTxWhenTransactionStarted, byte[] additionalHeader, LogPosition startPosition) {
        this(-2, masterId, authorId, timeWritten, lastCommittedTxWhenTransactionStarted, additionalHeader, startPosition);
    }

    public LogEntryStart(byte version, int masterId, int authorId, long timeWritten, long lastCommittedTxWhenTransactionStarted, byte[] additionalHeader, LogPosition startPosition) {
        super((byte)1, version);
        this.masterId = masterId;
        this.authorId = authorId;
        this.startPosition = startPosition;
        this.timeWritten = timeWritten;
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.additionalHeader = additionalHeader;
    }

    public int getMasterId() {
        return this.masterId;
    }

    public int getLocalId() {
        return this.authorId;
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(LogPosition position) {
        this.startPosition = position;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public long getLastCommittedTxWhenTransactionStarted() {
        return this.lastCommittedTxWhenTransactionStarted;
    }

    public byte[] getAdditionalHeader() {
        return this.additionalHeader;
    }

    public static long checksum(byte[] additionalHeader, int masterId, int authorId) {
        long lowBits = Arrays.hashCode(additionalHeader);
        long highBits = masterId * 37 + authorId;
        return highBits << 32 | lowBits & 0xFFFFFFFFL;
    }

    public static long checksum(LogEntryStart entry) {
        return LogEntryStart.checksum(entry.additionalHeader, entry.masterId, entry.authorId);
    }

    public long checksum() {
        return LogEntryStart.checksum(this);
    }

    public String toString() {
        return this.toString(Format.DEFAULT_TIME_ZONE);
    }

    @Override
    public void accept(LogHandler handler) throws IOException {
        handler.startEntry(this);
    }

    @Override
    public String toString(TimeZone timeZone) {
        return "Start[master=" + this.masterId + "," + "me=" + this.authorId + "," + "time=" + this.timestamp(this.timeWritten, timeZone) + "," + "lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + "," + "additionalHeaderLength=" + (this.additionalHeader == null ? -1 : this.additionalHeader.length) + "," + "position=" + this.startPosition + "," + "checksum=" + LogEntryStart.checksum(this) + "]";
    }

    @Override
    public <T extends LogEntry> T as() {
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryStart start = (LogEntryStart)o;
        if (this.authorId != start.authorId) {
            return false;
        }
        if (this.lastCommittedTxWhenTransactionStarted != start.lastCommittedTxWhenTransactionStarted) {
            return false;
        }
        if (this.masterId != start.masterId) {
            return false;
        }
        if (this.timeWritten != start.timeWritten) {
            return false;
        }
        if (!Arrays.equals(this.additionalHeader, start.additionalHeader)) {
            return false;
        }
        return this.startPosition.equals(start.startPosition);
    }

    public int hashCode() {
        int result = this.masterId;
        result = 31 * result + this.authorId;
        result = 31 * result + (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result = 31 * result + (int)(this.lastCommittedTxWhenTransactionStarted ^ this.lastCommittedTxWhenTransactionStarted >>> 32);
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.startPosition.hashCode();
        return result;
    }
}

