/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;

abstract class RotationStrategy<Meta> {
    protected final FileSystemAbstraction fs;
    protected final PageCache pages;
    private final ProgressiveFormat<Meta> format;

    RotationStrategy(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat<Meta> format) {
        this.fs = fs;
        this.pages = pages;
        this.format = format;
    }

    protected abstract File initialFile();

    protected abstract Iterable<File> candidateFiles();

    protected abstract File nextFile(File var1);

    public final Pair<File, KeyValueStoreFile<Meta>> open() throws IOException {
        KeyValueStoreFile result = null;
        File path = null;
        for (File candidatePath : this.candidateFiles()) {
            KeyValueStoreFile file;
            if (!this.fs.fileExists(candidatePath)) continue;
            try {
                file = this.format.openStore(this.fs, this.pages, candidatePath);
            }
            catch (Exception e) {
                this.format.failedToOpenStoreFile(candidatePath, e);
                continue;
            }
            if (result == null || this.format.compareMetadata(result.metadata(), file.metadata()) < 0) {
                if (result != null) {
                    result.close();
                }
                result = file;
                path = candidatePath;
                continue;
            }
            file.close();
        }
        return result == null ? null : Pair.of(path, result);
    }

    public final Pair<File, KeyValueStoreFile<Meta>> create() throws IOException {
        File path = this.initialFile();
        this.format.createEmptyStore(this.fs, path, this.format.keySize(), this.format.valueSize(), this.format.initialMetadata());
        return Pair.of(path, this.format.openStore(this.fs, this.pages, path));
    }

    public final Pair<File, KeyValueStoreFile<Meta>> next(File file, Meta meta, DataProvider data) throws IOException {
        KeyValueStoreFile<Meta> store;
        File path = this.nextFile(file);
        this.format.beforeRotation(file, path, meta);
        try {
            store = this.format.createStore(this.fs, this.pages, path, this.format.keySize(), this.format.valueSize(), meta, data);
        }
        catch (Exception e) {
            this.format.rotationFailed(file, path, meta, e);
            throw e;
        }
        this.format.rotationSucceeded(file, path, meta);
        return Pair.of(path, store);
    }

    final KeyValueStoreFile<Meta> openStoreFile(File path) throws IOException {
        return this.format.openStore(this.fs, this.pages, path);
    }

    static class Incrementing<Meta>
    extends RotationStrategy<Meta>
    implements FilenameFilter {
        private static final Pattern SUFFIX = Pattern.compile("\\.[0-9]+");
        private final File base;

        public Incrementing(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat<Meta> format, File base) {
            super(fs, pages, format);
            this.base = base;
        }

        @Override
        protected File initialFile() {
            return new File(this.base.getParent(), this.base.getName() + ".0");
        }

        @Override
        protected Iterable<File> candidateFiles() {
            return Arrays.asList(this.fs.listFiles(this.base.getParentFile(), (FilenameFilter)this));
        }

        @Override
        protected File nextFile(File previous) {
            int next;
            String name = previous.getName();
            int pos = name.lastIndexOf(46);
            try {
                int number = Integer.parseInt(name.substring(pos + 1));
                if (!this.base.getParent().equals(previous.getParent()) || !this.base.getName().equals(name.substring(0, pos))) {
                    throw new IllegalStateException("Invalid path: " + previous);
                }
                next = number + 1;
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Invalid path: " + previous, e);
            }
            return new File(this.base.getParent(), this.base.getName() + "." + next);
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.base.getName()) && SUFFIX.matcher(name.substring(this.base.getName().length())).matches();
        }
    }

    static class LeftRight<Meta>
    extends RotationStrategy<Meta> {
        private final File left;
        private final File right;

        LeftRight(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat<Meta> format, File left, File right) {
            super(fs, pages, format);
            this.left = left;
            this.right = right;
        }

        @Override
        protected File initialFile() {
            return this.left;
        }

        @Override
        protected Iterable<File> candidateFiles() {
            return Arrays.asList(this.left, this.right);
        }

        @Override
        protected File nextFile(File previous) {
            if (this.left.equals(previous)) {
                return this.right;
            }
            if (this.right.equals(previous)) {
                return this.left;
            }
            throw new IllegalStateException("Invalid path: " + previous);
        }
    }
}

