/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;

abstract class KeyValueStoreState<Key, Meta> {
    KeyValueStoreState() {
    }

    public abstract Meta metadata();

    public abstract boolean hasChanges();

    public abstract int totalRecordsStored();

    public abstract <Value> Value lookup(Key var1, AbstractKeyValueStore.Reader<Value> var2) throws IOException;

    public abstract DataProvider dataProvider() throws IOException;

    public abstract void apply(AbstractKeyValueStore.Update<Key> var1) throws IOException;

    public KeyValueStoreState<Key, Meta> init() throws IOException {
        throw new IllegalStateException("The store has already been initialised");
    }

    public KeyValueStoreState<Key, Meta> start() throws IOException {
        return this;
    }

    public abstract KeyValueStoreState<Key, Meta> rotate(Meta var1) throws IOException;

    public final KeyValueStoreState<Key, Meta> shutdown() throws IOException {
        if (this.hasChanges()) {
            throw new IllegalStateException("Cannot shutdown when there are changes");
        }
        return this.close();
    }

    abstract KeyValueStoreState<Key, Meta> close() throws IOException;

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract File file();

    abstract KeyValueStoreFile<Meta> openStoreFile(File var1) throws IOException;

    private static abstract class PreState<Key, Meta>
    extends KeyValueStoreState<Key, Meta> {
        private PreState() {
        }

        @Override
        public File file() {
            return null;
        }

        @Override
        public Meta metadata() {
            throw this.invalidState();
        }

        @Override
        public final boolean hasChanges() {
            return false;
        }

        @Override
        public final int totalRecordsStored() {
            throw this.invalidState();
        }

        @Override
        public final <Value> Value lookup(Key key, AbstractKeyValueStore.Reader<Value> request) throws IOException {
            throw this.invalidState();
        }

        @Override
        public final DataProvider dataProvider() throws IOException {
            throw this.invalidState();
        }

        @Override
        public final void apply(AbstractKeyValueStore.Update<Key> update) throws IOException {
            throw this.invalidState();
        }

        @Override
        public KeyValueStoreState<Key, Meta> init() throws IOException {
            throw this.invalidState();
        }

        @Override
        public KeyValueStoreState<Key, Meta> start() throws IOException {
            throw this.invalidState();
        }

        @Override
        public final KeyValueStoreState<Key, Meta> rotate(Meta metadata) throws IOException {
            throw this.invalidState();
        }

        abstract IllegalStateException invalidState();
    }

    static abstract class Stopped<Key, Meta>
    extends PreState<Key, Meta> {
        final RotationStrategy<Meta> rotation;

        Stopped(RotationStrategy<Meta> rotation) {
            this.rotation = rotation;
        }

        @Override
        public final KeyValueStoreState<Key, Meta> init() throws IOException {
            Pair<File, KeyValueStoreFile<Meta>> opened = this.rotation.open();
            if (opened == null) {
                return new Initialized();
            }
            return this.create(opened.first(), opened.other());
        }

        abstract KeyValueStoreState<Key, Meta> create(File var1, KeyValueStoreFile<Meta> var2);

        @Override
        final IllegalStateException invalidState() {
            return new IllegalStateException("The store has not been initialized.");
        }

        @Override
        final KeyValueStoreState<Key, Meta> close() throws IOException {
            return this;
        }

        @Override
        KeyValueStoreFile<Meta> openStoreFile(File path) throws IOException {
            return this.rotation.openStoreFile(path);
        }

        private class Initialized
        extends PreState<Key, Meta> {
            private Initialized() {
            }

            @Override
            public KeyValueStoreState<Key, Meta> start() throws IOException {
                Pair opened = Stopped.this.rotation.create();
                return Stopped.this.create(opened.first(), opened.other());
            }

            @Override
            public Meta metadata() {
                return null;
            }

            @Override
            KeyValueStoreState<Key, Meta> close() throws IOException {
                return Stopped.this;
            }

            @Override
            IllegalStateException invalidState() {
                return new IllegalStateException("The store has not been started.");
            }

            @Override
            KeyValueStoreFile<Meta> openStoreFile(File path) throws IOException {
                return Stopped.this.openStoreFile(path);
            }
        }
    }
}

