/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.Metadata;
import org.neo4j.kernel.impl.store.kvstore.SearchKey;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public class KeyValueStoreFile<META>
implements Closeable {
    private final PagedFile file;
    private final int keySize;
    private final int valueSize;
    private final META metadata;
    private final int headerRecords;
    private final int totalRecords;
    private final byte[] pageCatalogue;

    public META metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan(SearchKey search, KeyValueVisitor visitor) throws IOException {
        BigEndianByteArrayBuffer searchKey = BigEndianByteArrayBuffer.buffer(this.keySize);
        BigEndianByteArrayBuffer key = BigEndianByteArrayBuffer.buffer(this.keySize);
        BigEndianByteArrayBuffer value = BigEndianByteArrayBuffer.buffer(this.valueSize);
        search.searchKey(searchKey);
        int page = KeyValueStoreFile.findPage(searchKey, this.pageCatalogue);
        if (page < 0) {
            return false;
        }
        Throwable throwable = null;
        try (PageCursor cursor = this.file.io((long)page, 5);){
            boolean bl;
            if (!cursor.next()) {
                boolean bl2 = false;
                return bl2;
            }
            int offset = this.findOffset(cursor, searchKey, key, value);
            try {
                bl = Arrays.equals(searchKey.buffer, key.buffer);
            }
            catch (Throwable throwable2) {
                try {
                    KeyValueStoreFile.visitKeyValuePairs(this.file.pageSize(), cursor, offset, visitor, false, key, value);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            KeyValueStoreFile.visitKeyValuePairs(this.file.pageSize(), cursor, offset, visitor, false, key, value);
            return bl;
        }
    }

    public DataProvider dataProvider() throws IOException {
        int pageId = this.headerRecords * (this.keySize + this.valueSize) / this.file.pageSize();
        final PageCursor cursor = this.file.io((long)pageId, 5);
        return new DataProvider(){
            int offset;
            boolean done;
            {
                this.offset = KeyValueStoreFile.this.headerRecords * (KeyValueStoreFile.this.keySize + KeyValueStoreFile.this.valueSize);
                this.done = !cursor.next();
            }

            @Override
            public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                if (this.done) {
                    return false;
                }
                KeyValueStoreFile.readKeyValuePair(cursor, this.offset, key, value);
                if (key.allZeroes()) {
                    this.done = true;
                    return false;
                }
                this.offset += key.size() + value.size();
                if (this.offset >= KeyValueStoreFile.this.file.pageSize()) {
                    this.offset = 0;
                    if (!cursor.next()) {
                        this.done = true;
                    }
                }
                return true;
            }

            @Override
            public void close() throws IOException {
                cursor.close();
            }
        };
    }

    public void scan(KeyValueVisitor visitor) throws IOException {
        KeyValueStoreFile.scanAll(this.file, this.headerRecords * (this.keySize + this.valueSize), visitor, new BigEndianByteArrayBuffer(new byte[this.keySize]), new BigEndianByteArrayBuffer(new byte[this.valueSize]));
    }

    public int recordCount() {
        return this.totalRecords - this.headerRecords;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    KeyValueStoreFile(PagedFile file, int keySize, int valueSize, Metadata<META> metadata) {
        this.file = file;
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.headerRecords = metadata.headerRecords();
        this.totalRecords = metadata.totalRecords();
        this.metadata = metadata.metadata();
        this.pageCatalogue = metadata.pageCatalogue();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.file + "]";
    }

    static <Buffer extends BigEndianByteArrayBuffer> void scanAll(PagedFile file, int startOffset, EntryVisitor<? super Buffer> visitor, Buffer key, Buffer value) throws IOException {
        boolean visitMeta = !(visitor instanceof KeyValueVisitor);
        try (PageCursor cursor = file.io((long)(startOffset / file.pageSize()), 5);){
            if (!cursor.next()) {
                return;
            }
            KeyValueStoreFile.readKeyValuePair(cursor, startOffset, key, value);
            KeyValueStoreFile.visitKeyValuePairs(file.pageSize(), cursor, startOffset, visitor, visitMeta, key, value);
        }
    }

    private static <Buffer extends BigEndianByteArrayBuffer> void visitKeyValuePairs(int pageSize, PageCursor cursor, int offset, EntryVisitor<? super Buffer> visitor, boolean visitMeta, Buffer key, Buffer value) throws IOException {
        while (KeyValueStoreFile.visitable(key, visitMeta) && visitor.visit(key, value)) {
            if ((offset += key.size() + value.size()) >= pageSize) {
                offset = 0;
                if (!cursor.next()) {
                    return;
                }
            }
            KeyValueStoreFile.readKeyValuePair(cursor, offset, key, value);
        }
    }

    private static boolean visitable(BigEndianByteArrayBuffer key, boolean acceptZeroKey) {
        return acceptZeroKey || !key.allZeroes();
    }

    private static void readKeyValuePair(PageCursor cursor, int offset, WritableBuffer key, WritableBuffer value) throws IOException {
        do {
            cursor.setOffset(offset);
            key.getFrom(cursor);
            value.getFrom(cursor);
        } while (cursor.shouldRetry());
    }

    static int findPage(BigEndianByteArrayBuffer key, byte[] catalogue) {
        int max = catalogue.length / (key.size() * 2) - 1;
        int min = 0;
        while (min <= max) {
            int mid = min + (max - min) / 2;
            int cmp = BigEndianByteArrayBuffer.compare(key.buffer, catalogue, mid * key.size() * 2);
            if (cmp == 0) {
                max = mid;
            }
            if (cmp > 0) {
                cmp = BigEndianByteArrayBuffer.compare(key.buffer, catalogue, mid * key.size() * 2 + key.size());
                if (cmp <= 0) {
                    return mid;
                }
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    private int findOffset(PageCursor cursor, BigEndianByteArrayBuffer searchKey, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) throws IOException {
        int recordSize = searchKey.size() + value.size();
        int last = KeyValueStoreFile.maxPage(this.file.pageSize(), recordSize, this.totalRecords);
        int record = KeyValueStoreFile.recordOffset(cursor, searchKey, key, value, cursor.getCurrentPageId() == 0L ? this.headerRecords : 0, cursor.getCurrentPageId() == (long)last ? this.totalRecords % (this.file.pageSize() / recordSize) - 1 : this.file.pageSize() / recordSize);
        return record * recordSize;
    }

    static int maxPage(int pageSize, int recordSize, int totalRecords) {
        int maxPage = totalRecords / (pageSize / recordSize);
        return maxPage * (pageSize / recordSize) == totalRecords ? maxPage - 1 : maxPage;
    }

    static int recordOffset(PageCursor cursor, BigEndianByteArrayBuffer searchKey, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value, int min, int max) throws IOException {
        int recordSize = key.size() + value.size();
        while (min <= max) {
            int mid = min + (max - min) / 2;
            KeyValueStoreFile.readKeyValuePair(cursor, mid * recordSize, key, value);
            if (min == max) break;
            int cmp = BigEndianByteArrayBuffer.compare(searchKey.buffer, key.buffer, 0);
            if (cmp > 0) {
                min = mid + 1;
                continue;
            }
            max = mid;
        }
        return max;
    }
}

