/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueMerger;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreState;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

class ConcurrentMapState<Key, Meta>
extends KeyValueStoreState<Key, Meta> {
    private final RotationStrategy<Meta> rotation;
    private final KeyFormat<Key> keys;
    private final KeyValueStoreFile<Meta> store;
    private final ConcurrentMap<Key, byte[]> changes = new ConcurrentHashMap<Key, byte[]>();
    private final File file;

    private ConcurrentMapState(RotationStrategy<Meta> rotation, KeyFormat<Key> keys, KeyValueStoreFile<Meta> store, File file) {
        this.rotation = rotation;
        this.keys = keys;
        this.store = store;
        this.file = file;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.file + "]";
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    KeyValueStoreFile<Meta> openStoreFile(File path) throws IOException {
        return this.rotation.openStoreFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void apply(AbstractKeyValueStore.Update<Key> update) throws IOException {
        byte[] value = (byte[])this.changes.get(update.key);
        if (value == null) {
            byte[] proposal;
            byte[] byArray = proposal = new byte[this.keys.valueSize()];
            // MONITORENTER : proposal
            value = this.changes.putIfAbsent(update.key, proposal);
            if (value == null) {
                BigEndianByteArrayBuffer buffer = new BigEndianByteArrayBuffer(proposal);
                PreviousValue<Key> lookup = new PreviousValue<Key>(this.keys, update.key, proposal);
                if (!this.store.scan(lookup, lookup)) {
                    buffer.clear();
                }
                update.update(buffer);
                // MONITOREXIT : byArray
                return;
            }
            // MONITOREXIT : byArray
        }
        byte[] byArray = value;
        // MONITORENTER : value
        update.update(new BigEndianByteArrayBuffer(value));
        // MONITOREXIT : byArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueStoreState<Key, Meta> rotate(Meta metadata) throws IOException {
        try {
            Pair<File, KeyValueStoreFile<Meta>> next = this.rotation.next(this.file, metadata, this.keys.filter(this.dataProvider()));
            ConcurrentMapState<Key, Meta> concurrentMapState = new ConcurrentMapState<Key, Meta>(this.rotation, this.keys, next.other(), next.first());
            return concurrentMapState;
        }
        finally {
            this.store.close();
        }
    }

    @Override
    public Meta metadata() {
        return this.store.metadata();
    }

    @Override
    public KeyValueStoreState<Key, Meta> close() throws IOException {
        this.store.close();
        return null;
    }

    @Override
    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    @Override
    public <Value> Value lookup(Key key, AbstractKeyValueStore.Reader<Value> valueReader) throws IOException {
        byte[] value = (byte[])this.changes.get(key);
        if (value != null) {
            return valueReader.parseValue(new BigEndianByteArrayBuffer(value));
        }
        ValueFetcher<Key, Value> lookup = new ValueFetcher<Key, Value>(this.keys, key, valueReader);
        if (this.store.scan(lookup, lookup)) {
            return lookup.value;
        }
        return valueReader.defaultValue();
    }

    private byte[][] sortedUpdates() {
        Object[] buffer = new Entry[this.changes.size()];
        Iterator entries = this.changes.entrySet().iterator();
        for (int i = 0; i < buffer.length; ++i) {
            Map.Entry next = entries.next();
            byte[] key = new byte[this.keys.keySize()];
            this.keys.writeKey(next.getKey(), new BigEndianByteArrayBuffer(key));
            buffer[i] = new Entry(key, (byte[])next.getValue());
        }
        Arrays.sort(buffer);
        assert (!entries.hasNext()) : "We hold the lock, so we should see 'size' entries.";
        byte[][] result = new byte[buffer.length * 2][];
        for (int i = 0; i < buffer.length; ++i) {
            result[i * 2] = ((Entry)buffer[i]).key;
            result[i * 2 + 1] = ((Entry)buffer[i]).value;
        }
        return result;
    }

    @Override
    public DataProvider dataProvider() throws IOException {
        if (this.changes.isEmpty()) {
            return this.store.dataProvider();
        }
        return new KeyValueMerger(this.store.dataProvider(), new UpdateProvider(this.sortedUpdates()), this.keys.keySize(), this.keys.valueSize());
    }

    @Override
    public int totalRecordsStored() {
        return this.store.recordCount();
    }

    private static class UpdateProvider
    implements DataProvider {
        private final byte[][] data;
        private int i;

        UpdateProvider(byte[][] data) {
            this.data = data;
        }

        @Override
        public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
            if (this.i < this.data.length) {
                key.put(0, this.data[this.i]);
                value.put(0, this.data[this.i + 1]);
                this.i += 2;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class ValueFetcher<Key, Value>
    extends KeyFormat.Searcher<Key>
    implements KeyValueVisitor {
        private final AbstractKeyValueStore.Reader<Value> reader;
        Value value;

        ValueFetcher(KeyFormat<Key> keys, Key key, AbstractKeyValueStore.Reader<Value> reader) {
            super(keys, key);
            this.reader = reader;
        }

        @Override
        public boolean visit(ReadableBuffer key, ReadableBuffer value) {
            this.value = this.reader.parseValue(value);
            return false;
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        final byte[] key;
        final byte[] value;

        private Entry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Entry that) {
            return BigEndianByteArrayBuffer.compare(this.key, that.key, 0);
        }
    }

    private static class PreviousValue<Key>
    extends KeyFormat.Searcher<Key>
    implements KeyValueVisitor {
        private final byte[] proposal;

        PreviousValue(KeyFormat<Key> keys, Key key, byte[] proposal) {
            super(keys, key);
            this.proposal = proposal;
        }

        @Override
        public boolean visit(ReadableBuffer key, ReadableBuffer value) {
            value.get(0, this.proposal);
            return false;
        }
    }

    static class PreState<Key, Meta>
    extends KeyValueStoreState.Stopped<Key, Meta> {
        private final KeyFormat<Key> keys;

        PreState(RotationStrategy<Meta> rotation, KeyFormat<Key> keys) {
            super(rotation);
            this.keys = keys;
        }

        @Override
        KeyValueStoreState<Key, Meta> create(File path, KeyValueStoreFile<Meta> store) {
            return new ConcurrentMapState(this.rotation, this.keys, store, path);
        }
    }
}

