/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.pagecache.StandalonePageCache;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.Metadata;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;

public class DumpCountsStore
implements CountsVisitor,
MetadataVisitor<Metadata>,
UnknownKey.Visitor {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("one argument describing the path to the store");
            System.exit(1);
        }
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File path = new File(args[0]);
        try (StandalonePageCache pages = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, "counts-store-dump");
             Lifespan life = new Lifespan(new Lifecycle[0]);){
            if (fs.isDirectory(path)) {
                life.add(new StoreFactory((FileSystemAbstraction)fs, path, pages, StringLogger.DEV_NULL, new Monitors()).newCountsStore()).accept(new DumpCountsStore());
            } else {
                CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)fs, pages, path);
                if (fs.fileExists(path)) {
                    tracker.visitFile(path, new DumpCountsStore());
                } else {
                    life.add(tracker).accept(new DumpCountsStore());
                }
            }
        }
    }

    @Override
    public void visitMetadata(File path, Metadata metadata, int entryCount) {
        System.out.println("Counts Store:\t" + path);
        System.out.println("\ttxId:\t" + metadata.txId);
        System.out.println("\tminor version:\t" + metadata.minorVersion);
        System.out.println("\tentries:\t" + entryCount);
        System.out.println("Entries:");
    }

    @Override
    public void visitNodeCount(int labelId, long count) {
        System.out.println("\t" + CountsKeyFactory.nodeKey(labelId) + ":\t" + count);
    }

    @Override
    public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
        System.out.println("\t" + CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId) + ":\t" + count);
    }

    @Override
    public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
        System.out.println("\t" + CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId) + ":\tupdates=" + updates + ", size=" + size);
    }

    @Override
    public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        System.out.println("\t" + CountsKeyFactory.indexSampleKey(labelId, propertyKeyId) + ":\tunique=" + unique + ", size=" + size);
    }

    @Override
    public boolean visitUnknownKey(ReadableBuffer key, ReadableBuffer value) {
        System.out.println("\t" + key + ":\t" + value);
        return true;
    }
}

