/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.HighIdTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class TransactionRepresentationStoreApplier {
    private final NeoStore neoStore;
    private final IndexingService indexingService;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;
    private final LabelScanStore labelScanStore;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup;
    private final PropertyLoader propertyLoader;
    private final IdOrderingQueue legacyIndexTransactionOrdering;

    public TransactionRepresentationStoreApplier(IndexingService indexingService, LabelScanStore labelScanStore, NeoStore neoStore, CacheAccessBackDoor cacheAccess, LockService lockService, LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering) {
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.neoStore = neoStore;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.propertyLoader = new PropertyLoader(neoStore);
    }

    public void apply(TransactionRepresentation representation, LockGroup locks, long transactionId, TransactionApplicationMode mode) throws IOException {
        NeoCommandHandler storeApplier = new NeoStoreTransactionApplier(this.neoStore, this.cacheAccess, this.lockService, locks, transactionId);
        if (mode.needsIdTracking()) {
            storeApplier = new HighIdTransactionApplier(storeApplier, this.neoStore);
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            storeApplier = new CacheInvalidationTransactionApplier(storeApplier, this.neoStore, this.cacheAccess);
        }
        IndexTransactionApplier indexApplier = new IndexTransactionApplier(this.indexingService, this.labelScanStore, this.neoStore.getNodeStore(), this.neoStore.getPropertyStore(), this.cacheAccess, this.propertyLoader, transactionId, mode);
        LegacyIndexApplier legacyIndexApplier = new LegacyIndexApplier(this.indexConfigStore, this.legacyIndexProviderLookup, this.legacyIndexTransactionOrdering, transactionId, mode);
        NeoCommandHandler countsStoreApplier = this.getCountsStoreApplier(transactionId, mode);
        try (CommandApplierFacade applier = new CommandApplierFacade(storeApplier, indexApplier, legacyIndexApplier, countsStoreApplier);){
            representation.accept(applier);
        }
    }

    private NeoCommandHandler getCountsStoreApplier(long transactionId, TransactionApplicationMode mode) {
        CountsTracker counts = this.neoStore.getCounts();
        if (TransactionApplicationMode.RECOVERY == mode && !counts.acceptTx(transactionId)) {
            return NeoCommandHandler.EMPTY;
        }
        assert (counts.acceptTx(transactionId)) : counts;
        return new CountsStoreApplier(counts.updater(), this.neoStore.getNodeStore());
    }
}

