/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Collection;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public class InputRelationship
extends InputEntity {
    private final long id;
    private final Object startNode;
    private final Object endNode;
    private String type;
    private final Integer typeId;
    private final Group startNodeGroup;
    private final Group endNodeGroup;

    public InputRelationship(long id, Object[] properties, Long firstPropertyId, Object startNode, Object endNode, String type, Integer typeId) {
        this(id, properties, firstPropertyId, Group.GLOBAL, startNode, Group.GLOBAL, endNode, type, typeId);
    }

    public InputRelationship(long id, Object[] properties, Long firstPropertyId, Group startNodeGroups, Object startNode, Group endNodeGroups, Object endNode, String type, Integer typeId) {
        super(properties, firstPropertyId);
        this.id = id;
        this.startNodeGroup = startNodeGroups;
        this.startNode = startNode;
        this.endNodeGroup = endNodeGroups;
        this.endNode = endNode;
        this.type = type;
        this.typeId = typeId;
    }

    public long id() {
        return this.id;
    }

    public Group startNodeGroup() {
        return this.startNodeGroup;
    }

    public Object startNode() {
        return this.startNode;
    }

    public Group endNodeGroup() {
        return this.endNodeGroup;
    }

    public Object endNode() {
        return this.endNode;
    }

    public boolean isLoop() {
        return this.startNode.equals(this.endNode);
    }

    public Direction startDirection() {
        return this.isLoop() ? Direction.BOTH : Direction.OUTGOING;
    }

    public String type() {
        return this.type;
    }

    public boolean hasTypeId() {
        return this.typeId != null;
    }

    public int typeId() {
        return this.typeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        super.toStringFields(fields);
        fields.add(Pair.of("startNode", this.startNode));
        fields.add(Pair.of("endNode", this.endNode));
        if (this.hasTypeId()) {
            fields.add(Pair.of("typeId", this.typeId));
        } else {
            fields.add(Pair.of("type", this.type));
        }
    }
}

