/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.concurrent.CountDownLatch;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.RadixCalculator;

public class ParallelSort {
    private final int[] radixIndexCount;
    private final RadixCalculator radixCalculator;
    private final LongArray dataCache;
    private final IntArray tracker;
    private final int threads;
    private long[][] sortBuckets;

    public ParallelSort(Radix radix, LongArray dataCache, IntArray tracker, int threads) {
        this.radixIndexCount = radix.getRadixIndexCounts();
        this.radixCalculator = radix.calculator();
        this.dataCache = dataCache;
        this.tracker = tracker;
        this.threads = threads;
    }

    public long[][] run() {
        int[][] sortParams = this.sortRadix();
        int threadsNeeded = 0;
        for (int i = 0; i < this.threads && sortParams[i][1] != 0; ++i) {
            ++threadsNeeded;
        }
        CountDownLatch waitSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(threadsNeeded);
        SortWorker[] sortWorker = new SortWorker[threadsNeeded];
        for (int i = 0; i < threadsNeeded && sortParams[i][1] != 0; ++i) {
            sortWorker[i] = new SortWorker(i, sortParams[i][0], sortParams[i][1], waitSignal, doneSignal);
            sortWorker[i].start();
        }
        waitSignal.countDown();
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.sortBuckets;
    }

    private int[][] sortRadix() {
        int[][] rangeParams = new int[this.threads][2];
        int[] bucketRange = new int[this.threads];
        this.sortBuckets = new long[this.threads][2];
        int bucketSize = (int)(this.dataCache.size() / (long)this.threads);
        int count = 0;
        int fullCount = 0;
        rangeParams[0][0] = 0;
        bucketRange[0] = 0;
        int threadIndex = 0;
        for (int i = 0; i < this.radixIndexCount.length && threadIndex < this.threads; ++i) {
            if (count + this.radixIndexCount[i] > bucketSize) {
                bucketRange[threadIndex] = count == 0 ? i : i - 1;
                rangeParams[threadIndex][0] = fullCount;
                if (count != 0) {
                    rangeParams[threadIndex][1] = count;
                    fullCount += count;
                    count = this.radixIndexCount[i];
                } else {
                    rangeParams[threadIndex][1] = this.radixIndexCount[i];
                    fullCount += this.radixIndexCount[i];
                }
                ++threadIndex;
            } else {
                count += this.radixIndexCount[i];
            }
            if (threadIndex != this.threads - 1 && i != this.radixIndexCount.length - 1) continue;
            bucketRange[threadIndex] = this.radixIndexCount.length;
            rangeParams[threadIndex][0] = fullCount;
            rangeParams[threadIndex][1] = (int)this.dataCache.size() - fullCount;
            break;
        }
        int[] bucketIndex = new int[this.threads];
        for (int i = 0; i < this.threads; ++i) {
            bucketIndex[i] = 0;
        }
        block2: for (long i = 0L; i < this.dataCache.size(); ++i) {
            int rIndex = this.radixCalculator.radixOf(this.dataCache.get(i));
            for (int k = 0; k < this.threads; ++k) {
                if (rIndex > bucketRange[k]) continue;
                int n = k;
                int n2 = bucketIndex[n];
                bucketIndex[n] = n2 + 1;
                long temp = rangeParams[k][0] + n2;
                assert (this.tracker.get(temp) == -1);
                this.tracker.set(temp, (int)i);
                if (bucketIndex[k] != rangeParams[k][1]) continue block2;
                this.sortBuckets[k][0] = bucketRange[k];
                this.sortBuckets[k][1] = rangeParams[k][0];
                continue block2;
            }
        }
        return rangeParams;
    }

    private int partition(int leftIndex, int rightIndex, int pivotIndex) {
        int li = leftIndex;
        int ri = rightIndex - 2;
        int pi = pivotIndex;
        long pivot = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(pi)));
        ParallelSort.swapElement(this.tracker, pi, rightIndex - 1);
        long left = 0L;
        long right = 0L;
        while (li < ri) {
            left = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(li)));
            right = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(ri)));
            if (Utils.unsignedCompare(left, pivot, Utils.CompareType.LT)) {
                ++li;
                continue;
            }
            if (Utils.unsignedCompare(right, pivot, Utils.CompareType.GE)) {
                --ri;
                continue;
            }
            ParallelSort.swapElement(this.tracker, li, ri);
        }
        int partingIndex = ri;
        right = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(ri)));
        if (Utils.unsignedCompare(right, pivot, Utils.CompareType.LT)) {
            ++partingIndex;
        }
        ParallelSort.swapElement(this.tracker, rightIndex - 1, partingIndex);
        return partingIndex;
    }

    public void recursiveQsort(int start, int end) {
        if (end - start < 2) {
            return;
        }
        int pivot = start + (end - start) / 2;
        pivot = this.partition(start, end, pivot);
        this.recursiveQsort(start, pivot);
        this.recursiveQsort(pivot + 1, end);
    }

    private static void swapElement(IntArray trackerCache, int left, int right) {
        trackerCache.swap(left, right, 1);
    }

    private class SortWorker
    extends Thread {
        private final int start;
        private final int size;
        private final CountDownLatch doneSignal;
        private final CountDownLatch waitSignal;
        private int workerId = -1;

        SortWorker(int workerId, int startRange, int size, CountDownLatch wait, CountDownLatch done) {
            this.start = startRange;
            this.size = size;
            this.doneSignal = done;
            this.waitSignal = wait;
            this.workerId = workerId;
        }

        @Override
        public void run() {
            this.setName("SortWorker-" + this.workerId);
            try {
                this.waitSignal.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ParallelSort.this.recursiveQsort(this.start, this.start + this.size);
            this.doneSignal.countDown();
        }
    }
}

