/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.AvailableMemoryCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;

public interface NumberArrayFactory {
    public static final NumberArrayFactory HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return new HeapIntArray(Utils.safeCastLongToInt(length), defaultValue);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return new HeapLongArray(Utils.safeCastLongToInt(length), defaultValue);
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return new OffHeapIntArray(length, defaultValue);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return new OffHeapLongArray(length, defaultValue);
        }
    };
    public static final NumberArrayFactory CHUNKED_STATIC = new Adapter(){

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return this.newDynamicLongArray(this.fractionOf(length), defaultValue);
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return this.newDynamicIntArray(this.fractionOf(length), defaultValue);
        }

        private long fractionOf(long length) {
            return length / 10L;
        }

        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray(AUTO, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray(AUTO, chunkSize, defaultValue);
        }
    };
    public static final NumberArrayFactory AUTO = new Auto(AvailableMemoryCalculator.RUNTIME, 314572800L);

    public IntArray newIntArray(long var1, int var3);

    public IntArray newDynamicIntArray(long var1, int var3);

    public LongArray newLongArray(long var1, long var3);

    public LongArray newDynamicLongArray(long var1, long var3);

    public static class Auto
    extends Adapter {
        private final AvailableMemoryCalculator calculator;
        private final long margin;

        public Auto(AvailableMemoryCalculator calculator, long margin) {
            this.calculator = calculator;
            this.margin = margin;
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return this.mostAppropriateFactory(length, 8).newLongArray(length, defaultValue);
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return this.mostAppropriateFactory(length, 4).newIntArray(length, defaultValue);
        }

        private NumberArrayFactory mostAppropriateFactory(long length, int i) {
            long bytesRequired = length * 8L;
            long freeOffHeap = this.calculator.availableOffHeapMemory() - this.margin;
            if (bytesRequired < freeOffHeap) {
                return OFF_HEAP;
            }
            long freeHeap = this.calculator.availableHeapMemory() - this.margin;
            if (bytesRequired < Integer.MAX_VALUE && bytesRequired < freeHeap) {
                try {
                    return HEAP;
                }
                catch (OutOfMemoryError e) {
                    // empty catch block
                }
            }
            if (bytesRequired < freeHeap + freeOffHeap) {
                return CHUNKED_STATIC;
            }
            throw new IllegalArgumentException(String.format("Neither enough free heap (%d), nor off-heap (%d) space for allocating %s", freeHeap, freeOffHeap, Format.bytes(bytesRequired)));
        }
    }

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray(this, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray(this, chunkSize, defaultValue);
        }
    }
}

