/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeLabelsCache
implements MemoryStatsVisitor.Home {
    private final LongArray cache;
    private final LongArray spillOver;
    private long spillOverIndex;
    private final int bitsPerLabel;
    private final long[] labelScratch;
    private final Bits labelBits;
    private final long[] fieldScratch = new long[1];
    private final Bits fieldBits = Bits.bitsFromLongs(this.fieldScratch);

    public NodeLabelsCache(NumberArrayFactory cacheFactory, int highLabelId) {
        this(cacheFactory, highLabelId, 10000000);
    }

    public NodeLabelsCache(NumberArrayFactory cacheFactory, int highLabelId, int chunkSize) {
        this.cache = cacheFactory.newDynamicLongArray(chunkSize, 0L);
        this.spillOver = cacheFactory.newDynamicLongArray(chunkSize / 5, 0L);
        this.bitsPerLabel = 32 - Integer.numberOfLeadingZeros(highLabelId);
        int worstCaseLongsNeeded = (this.bitsPerLabel * (highLabelId + 1) - 1) / 64 + 1;
        this.labelScratch = new long[worstCaseLongsNeeded];
        this.labelBits = Bits.bitsFromLongs(this.labelScratch);
    }

    public void put(long nodeId, long[] labelIds) {
        this.labelBits.clear(true);
        this.labelBits.put(labelIds.length, this.bitsPerLabel);
        for (long labelId : labelIds) {
            this.labelBits.put((int)labelId, this.bitsPerLabel);
        }
        int longsInUse = this.labelBits.longsInUse();
        assert (longsInUse > 0) : "Uhm";
        if (longsInUse == 1) {
            this.cache.set(nodeId, this.labelScratch[0]);
        } else {
            this.fieldBits.clear(true);
            this.fieldBits.put(labelIds.length, this.bitsPerLabel);
            this.fieldBits.put(this.spillOverIndex, 64 - this.bitsPerLabel);
            this.cache.set(nodeId, this.fieldBits.getLongs()[0]);
            for (int i = 0; i < longsInUse; ++i) {
                this.spillOver.set(this.spillOverIndex++, this.labelScratch[i]);
            }
        }
    }

    public int[] get(long nodeId, int[] target) {
        this.fieldBits.clear(false);
        this.fieldScratch[0] = this.cache.get(nodeId);
        if (this.fieldScratch[0] == 0L) {
            target[0] = -1;
            return target;
        }
        int length = this.fieldBits.getInt(this.bitsPerLabel);
        int longsInUse = (this.bitsPerLabel * (length + 1) - 1) / 64 + 1;
        target = NodeLabelsCache.ensureCapacity(target, length);
        if (longsInUse == 1) {
            this.decode(this.fieldBits, length, target);
        } else {
            long spillOverIndex = this.fieldBits.getLong(64 - this.bitsPerLabel);
            this.labelBits.clear(false);
            for (int i = 0; i < longsInUse; ++i) {
                this.labelScratch[i] = this.spillOver.get(spillOverIndex + (long)i);
            }
            this.labelBits.getInt(this.bitsPerLabel);
            this.decode(this.labelBits, length, target);
        }
        return target;
    }

    @Override
    public void visit(MemoryStatsVisitor visitor) {
        this.cache.visit(visitor);
        this.spillOver.visit(visitor);
    }

    private void decode(Bits bits, int length, int[] target) {
        for (int i = 0; i < length; ++i) {
            target[i] = bits.getInt(this.bitsPerLabel);
        }
        if (target.length > length) {
            target[length] = -1;
        }
    }

    private static int[] ensureCapacity(int[] target, int capacity) {
        return capacity > target.length ? new int[capacity] : target;
    }

    public void close() {
        this.cache.close();
        this.spillOver.close();
    }
}

