/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;

public class Utils {
    public static int safeCastLongToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (int)value;
    }

    public static short safeCastLongToShort(long value) {
        if (value > 32767L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (short)value;
    }

    public static byte safeCastLongToByte(long value) {
        if (value > 127L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (byte)value;
    }

    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType) {
            case EQ: {
                return dataA == dataB;
            }
            case GE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case GT: {
                return !(dataA < dataB ^ dataA < 0L != dataB < 0L);
            }
            case LE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case LT: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
        }
        return false;
    }

    public static ResourceIterable<Object> idsOf(final ResourceIterable<InputNode> nodes) {
        return new ResourceIterable<Object>(){

            @Override
            public ResourceIterator<Object> iterator() {
                return new PrefetchingResourceIterator<Object>(){
                    private final ResourceIterator<InputNode> iterator;
                    {
                        this.iterator = nodes.iterator();
                    }

                    @Override
                    public void close() {
                        this.iterator.close();
                    }

                    @Override
                    protected Object fetchNextOrNull() {
                        return this.iterator.hasNext() ? ((InputNode)this.iterator.next()).id() : null;
                    }
                };
            }
        };
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

