/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.BatchEntity;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipEncoderStep
extends ExecutorServiceStep<Pair<List<InputRelationship>, long[]>> {
    private final BatchingTokenRepository<?> relationshipTypeRepository;
    private final RelationshipStore relationshipStore;
    private final NodeRelationshipLink nodeRelationshipLink;

    public RelationshipEncoderStep(StageControl control, Configuration config, BatchingTokenRepository<?> relationshipTypeRepository, RelationshipStore relationshipStore, NodeRelationshipLink nodeRelationshipLink) {
        super(control, "RELATIONSHIP", config.workAheadSize(), config.movingAverageSize(), 1);
        this.relationshipTypeRepository = relationshipTypeRepository;
        this.relationshipStore = relationshipStore;
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected Object process(long ticket, Pair<List<InputRelationship>, long[]> batch) {
        ArrayList<BatchEntity<RelationshipRecord, InputRelationship>> entities = new ArrayList<BatchEntity<RelationshipRecord, InputRelationship>>(batch.first().size());
        long[] startAndEndNodeIds = batch.other();
        int index = 0;
        for (InputRelationship batchRelationship : batch.first()) {
            long relationshipId = batchRelationship.id();
            long startNodeId = startAndEndNodeIds[index++];
            long endNodeId = startAndEndNodeIds[index++];
            this.relationshipStore.setHighestPossibleIdInUse(relationshipId);
            int typeId = batchRelationship.hasTypeId() ? batchRelationship.typeId() : this.relationshipTypeRepository.getOrCreateId(batchRelationship.type());
            RelationshipRecord relationshipRecord = new RelationshipRecord(relationshipId, startNodeId, endNodeId, typeId);
            relationshipRecord.setInUse(true);
            long firstNextRel = this.nodeRelationshipLink.getAndPutRelationship(startNodeId, typeId, batchRelationship.startDirection(), relationshipId, true);
            relationshipRecord.setFirstNextRel(firstNextRel);
            if (batchRelationship.isLoop()) {
                relationshipRecord.setSecondNextRel(firstNextRel);
            } else {
                relationshipRecord.setSecondNextRel(this.nodeRelationshipLink.getAndPutRelationship(endNodeId, typeId, Direction.INCOMING, relationshipId, true));
            }
            relationshipRecord.setFirstInFirstChain(false);
            relationshipRecord.setFirstInSecondChain(false);
            relationshipRecord.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            relationshipRecord.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            entities.add(new BatchEntity<RelationshipRecord, InputRelationship>(relationshipRecord, batchRelationship));
        }
        return entities;
    }
}

