/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.List;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.unsafe.impl.batchimport.BatchEntity;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelativeIdRecordAllocator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStep<ENTITY extends PrimitiveRecord, INPUT extends InputEntity>
extends ExecutorServiceStep<List<BatchEntity<ENTITY, INPUT>>> {
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder;
    private final int arrayDataSize;
    private final int stringDataSize;

    protected PropertyEncoderStep(StageControl control, Configuration config, int numberOfExecutors, BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder, PropertyStore propertyStore) {
        super(control, "PROPERTIES", config.workAheadSize(), config.movingAverageSize(), numberOfExecutors, true);
        this.propertyKeyHolder = propertyKeyHolder;
        this.arrayDataSize = propertyStore.getArrayStore().dataSize();
        this.stringDataSize = propertyStore.getStringStore().dataSize();
    }

    @Override
    protected Object process(long ticket, List<BatchEntity<ENTITY, INPUT>> batch) {
        RelativeIdRecordAllocator stringAllocator = new RelativeIdRecordAllocator(this.stringDataSize);
        RelativeIdRecordAllocator arrayAllocator = new RelativeIdRecordAllocator(this.arrayDataSize);
        PropertyCreator propertyCreator = new PropertyCreator(stringAllocator, arrayAllocator, null, null);
        for (BatchEntity<ENTITY, INPUT> entity : batch) {
            INPUT input = entity.input();
            stringAllocator.initialize();
            arrayAllocator.initialize();
            if (((InputEntity)input).hasFirstPropertyId()) {
                long nextProp = ((InputEntity)input).firstPropertyId();
                ((PrimitiveRecord)entity.record()).setNextProp(nextProp);
                continue;
            }
            PropertyBlock[] blocks = this.propertyKeyHolder.propertyKeysAndValues(((InputEntity)entity.input()).properties(), propertyCreator);
            entity.setPropertyBlocks(blocks);
        }
        return batch;
    }
}

