/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.function.Function;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.NodeCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipProcessor;
import org.neo4j.unsafe.impl.batchimport.NodeStoreProcessorStage;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackProcessor;
import org.neo4j.unsafe.impl.batchimport.RelationshipPreparationStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipStoreProcessorStage;
import org.neo4j.unsafe.impl.batchimport.StoreProcessor;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.cache.AvailableMemoryCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLinkImpl;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisor;
import org.neo4j.unsafe.impl.batchimport.staging.IteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final String storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final IoMonitor writeMonitor;
    private final ExecutionSupervisor executionPoller;
    private final Logging logging;
    private final StringLogger logger;
    private final Monitors monitors;
    private final BatchingPageCache.WriterFactory writerFactory;
    private final AdditionalInitialIds additionalInitialIds;
    private final AvailableMemoryCalculator memoryCalculator;

    public ParallelBatchImporter(String storeDir, FileSystemAbstraction fileSystem, Configuration config, Logging logging, ExecutionMonitor executionMonitor, Function<Configuration, BatchingPageCache.WriterFactory> writerFactory, AdditionalInitialIds additionalInitialIds, AvailableMemoryCalculator memoryCalculator) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logging = logging;
        this.additionalInitialIds = additionalInitialIds;
        this.memoryCalculator = memoryCalculator;
        this.logger = logging.getMessagesLog(this.getClass());
        this.executionPoller = new ExecutionSupervisor(Clock.SYSTEM_CLOCK, new MultiExecutionMonitor(executionMonitor, new DynamicProcessorAssigner(config, config.maxNumberOfProcessors())));
        this.monitors = new Monitors();
        this.writeMonitor = new IoMonitor();
        this.writerFactory = (BatchingPageCache.WriterFactory)writerFactory.apply((Object)config);
    }

    public ParallelBatchImporter(String storeDir, Configuration config, Logging logging, ExecutionMonitor executionMonitor) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), config, logging, executionMonitor, WriterFactories.parallel(), AdditionalInitialIds.EMPTY, AvailableMemoryCalculator.RUNTIME);
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.logger.info("Import starting");
        NodeRelationshipLink nodeRelationshipLink = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        try (BatchingNeoStore neoStore = new BatchingNeoStore(this.fileSystem, this.storeDir, this.config, this.writeMonitor, this.logging, this.monitors, this.writerFactory, this.additionalInitialIds);){
            IdMapper idMapper = input.idMapper();
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipLink = new NodeRelationshipLinkImpl(NumberArrayFactory.AUTO, this.config.denseNodeThreshold());
            ResourceIterable<InputNode> nodes = input.nodes();
            ResourceIterable<InputRelationship> relationships = input.relationships();
            NodeStage nodeStage = new NodeStage(nodes, idMapper, idGenerator, neoStore);
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(relationships, nodeRelationshipLink, idMapper);
            if (idMapper.needsPreparation()) {
                this.executeStages(nodeStage);
                this.executeStages(calculateDenseNodesStage);
            } else {
                this.executeStages(nodeStage, calculateDenseNodesStage);
            }
            RelationshipStage relationshipStage = new RelationshipStage(relationships, idMapper, neoStore, nodeRelationshipLink);
            this.executeStages(relationshipStage);
            this.writerFactory.awaitEverythingWritten();
            neoStore.switchToUpdateMode();
            idMapper = null;
            idGenerator = null;
            nodeLabelsCache = new NodeLabelsCache(NumberArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            NodeFirstRelationshipProcessor nodeFirstRelationshipProcessor = new NodeFirstRelationshipProcessor(neoStore.getRelationshipGroupStore(), nodeRelationshipLink);
            NodeCountsProcessor nodeCountsProcessor = new NodeCountsProcessor(neoStore.getNodeStore(), nodeLabelsCache, neoStore.getLabelRepository().getHighId(), neoStore.getCountsStore());
            RelationshipLinkbackProcessor relationshipLinkerProcessor = new RelationshipLinkbackProcessor(nodeRelationshipLink);
            RelationshipCountsProcessor relationshipCountsProcessor = new RelationshipCountsProcessor(nodeLabelsCache, neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), neoStore.getCountsStore());
            if (this.enoughAvailableMemoryForRemainingProcessors(nodeRelationshipLink)) {
                this.executeStages(new NodeStoreProcessorStage("Node --> Relationship + counts", this.config, neoStore.getNodeStore(), new StoreProcessor.Multiple<NodeRecord>(nodeFirstRelationshipProcessor, nodeCountsProcessor)));
                nodeRelationshipLink.clearRelationships();
                this.executeStages(new RelationshipStoreProcessorStage("Relationship --> Relationship + counts", this.config, neoStore.getRelationshipStore(), new StoreProcessor.Multiple<RelationshipRecord>(relationshipLinkerProcessor, relationshipCountsProcessor)));
            } else {
                this.executeStages(new NodeStoreProcessorStage("Node --> Relationship", this.config, neoStore.getNodeStore(), nodeFirstRelationshipProcessor));
                nodeRelationshipLink.clearRelationships();
                this.executeStages(new RelationshipStoreProcessorStage("Relationship --> Relationship", this.config, neoStore.getRelationshipStore(), relationshipLinkerProcessor));
                nodeRelationshipLink.close();
                nodeRelationshipLink = null;
                this.executeStages(new NodeStoreProcessorStage("Node --> Relationship", this.config, neoStore.getNodeStore(), nodeCountsProcessor));
                this.executeStages(new RelationshipStoreProcessorStage("Relationship --> Relationship", this.config, neoStore.getRelationshipStore(), relationshipCountsProcessor));
            }
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionPoller.done(totalTimeMillis);
            this.logger.info("Import completed, took " + Format.duration(totalTimeMillis));
        }
        catch (Throwable t) {
            this.logger.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            this.writerFactory.shutdown();
            if (nodeRelationshipLink != null) {
                nodeRelationshipLink.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
        }
    }

    private boolean enoughAvailableMemoryForRemainingProcessors(NodeRelationshipLink nodeRelationshipLink) {
        GatheringMemoryStatsVisitor usedMemory = new GatheringMemoryStatsVisitor();
        nodeRelationshipLink.visit(usedMemory);
        long used = usedMemory.getHeapUsage() + usedMemory.getOffHeapUsage();
        long available = this.memoryCalculator.availableHeapMemory() + this.memoryCalculator.availableOffHeapMemory();
        return available > used * 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeStages(Stage ... stages) {
        try {
            StageExecution[] executions = new StageExecution[stages.length];
            for (int i = 0; i < stages.length; ++i) {
                executions[i] = stages[i].execute();
            }
            this.executionPoller.supervise(executions);
        }
        finally {
            for (Stage stage : stages) {
                stage.close();
            }
        }
    }

    public class RelationshipStage
    extends Stage {
        public RelationshipStage(ResourceIterable<InputRelationship> relationships, IdMapper idMapper, BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super("Relationships", ParallelBatchImporter.this.config);
            this.add(new IteratorBatcherStep<InputRelationship>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), ParallelBatchImporter.this.config.movingAverageSize(), relationships.iterator()));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new RelationshipPreparationStep(this.control(), ParallelBatchImporter.this.config, idMapper));
            this.add(new RelationshipEncoderStep(this.control(), ParallelBatchImporter.this.config, neoStore.getRelationshipTypeRepository(), relationshipStore, nodeRelationshipLink));
            this.add(new PropertyEncoderStep(this.control(), ParallelBatchImporter.this.config, 1, neoStore.getPropertyKeyRepository(), propertyStore));
            this.add(new EntityStoreUpdaterStep(this.control(), ParallelBatchImporter.this.config, relationshipStore, propertyStore, ParallelBatchImporter.this.writeMonitor, ParallelBatchImporter.this.writerFactory));
        }
    }

    public class CalculateDenseNodesStage
    extends Stage {
        public CalculateDenseNodesStage(ResourceIterable<InputRelationship> relationships, NodeRelationshipLink nodeRelationshipLink, IdMapper idMapper) {
            super("Calculate dense nodes", ParallelBatchImporter.this.config);
            this.add(new IteratorBatcherStep<InputRelationship>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), ParallelBatchImporter.this.config.movingAverageSize(), relationships.iterator()));
            this.add(new RelationshipPreparationStep(this.control(), ParallelBatchImporter.this.config, idMapper));
            this.add(new CalculateDenseNodesStep(this.control(), ParallelBatchImporter.this.config, nodeRelationshipLink));
        }
    }

    public class NodeStage
    extends Stage {
        public NodeStage(ResourceIterable<InputNode> nodes, IdMapper idMapper, IdGenerator idGenerator, BatchingNeoStore neoStore) {
            super("Nodes", ParallelBatchImporter.this.config);
            this.add(new IteratorBatcherStep<InputNode>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), ParallelBatchImporter.this.config.movingAverageSize(), nodes.iterator()));
            NodeStore nodeStore = neoStore.getNodeStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new NodeEncoderStep(this.control(), ParallelBatchImporter.this.config, idMapper, idGenerator, neoStore.getLabelRepository(), nodeStore, Utils.idsOf(nodes)));
            this.add(new PropertyEncoderStep(this.control(), ParallelBatchImporter.this.config, 1, neoStore.getPropertyKeyRepository(), propertyStore));
            this.add(new EntityStoreUpdaterStep(this.control(), ParallelBatchImporter.this.config, nodeStore, propertyStore, ParallelBatchImporter.this.writeMonitor, ParallelBatchImporter.this.writerFactory));
        }
    }
}

