/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.unsafe.impl.batchimport.BatchEntity;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public final class NodeEncoderStep
extends ExecutorServiceStep<List<InputNode>> {
    private final IdMapper idMapper;
    private final IdGenerator idGenerator;
    private final NodeStore nodeStore;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelHolder;
    private final ResourceIterable<Object> allIds;

    public NodeEncoderStep(StageControl control, Configuration config, IdMapper idMapper, IdGenerator idGenerator, BatchingTokenRepository.BatchingLabelTokenRepository labelHolder, NodeStore nodeStore, ResourceIterable<Object> allIds) {
        super(control, "NODE", config.workAheadSize(), config.movingAverageSize(), 1);
        this.idMapper = idMapper;
        this.idGenerator = idGenerator;
        this.nodeStore = nodeStore;
        this.labelHolder = labelHolder;
        this.allIds = allIds;
    }

    @Override
    protected Object process(long ticket, List<InputNode> batch) {
        ArrayList<BatchEntity<NodeRecord, InputNode>> entities = new ArrayList<BatchEntity<NodeRecord, InputNode>>(batch.size());
        for (InputNode batchNode : batch) {
            long nodeId = this.idGenerator.generate(batchNode.id());
            if (batchNode.id() != null) {
                this.idMapper.put(batchNode.id(), nodeId, batchNode.group());
            }
            NodeRecord nodeRecord = new NodeRecord(nodeId, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            nodeRecord.setInUse(true);
            entities.add(new BatchEntity<NodeRecord, InputNode>(nodeRecord, batchNode));
            if (batchNode.hasLabelField()) {
                nodeRecord.setLabelField(batchNode.labelField(), Collections.emptyList());
                continue;
            }
            long[] labels = this.labelHolder.getOrCreateIds(batchNode.labels());
            InlineNodeLabels.put(nodeRecord, labels, null, this.nodeStore.getDynamicLabelStore());
        }
        return entities;
    }

    @Override
    protected void done() {
        this.idMapper.prepare(this.allIds);
        super.done();
    }
}

