/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;

public interface Configuration {
    public static final Configuration DEFAULT = new Default();

    public int batchSize();

    public int fileChannelBufferSize();

    public int workAheadSize();

    public int denseNodeThreshold();

    public int maxNumberOfIoProcessors();

    public int maxNumberOfProcessors();

    public int movingAverageSize();

    public static class OverrideFromConfig
    implements Configuration {
        private final Configuration defaults;
        private final Config config;

        public OverrideFromConfig(Configuration defaults, Config config) {
            this.defaults = defaults;
            this.config = config;
        }

        public OverrideFromConfig(Config config) {
            this(DEFAULT, config);
        }

        @Override
        public int batchSize() {
            return this.defaults.batchSize();
        }

        @Override
        public int fileChannelBufferSize() {
            return this.defaults.fileChannelBufferSize();
        }

        @Override
        public int workAheadSize() {
            return this.defaults.workAheadSize();
        }

        @Override
        public int denseNodeThreshold() {
            return this.config.get(GraphDatabaseSettings.dense_node_threshold);
        }

        @Override
        public int maxNumberOfIoProcessors() {
            return this.defaults.maxNumberOfIoProcessors();
        }

        @Override
        public int maxNumberOfProcessors() {
            return this.defaults.maxNumberOfProcessors();
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }
    }

    public static class Default
    implements Configuration {
        private static final int OPTIMAL_FILE_CHANNEL_CHUNK_SIZE = 4096;

        @Override
        public int batchSize() {
            return 10000;
        }

        @Override
        public int fileChannelBufferSize() {
            return this.roundToClosest(this.batchSize() * 40, 4096);
        }

        private int roundToClosest(int value, int divisible) {
            double roughCount = (double)value / (double)divisible;
            int count = (int)Math.round(roughCount);
            return divisible * count;
        }

        @Override
        public int workAheadSize() {
            return 20;
        }

        @Override
        public int denseNodeThreshold() {
            return Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        }

        @Override
        public int maxNumberOfIoProcessors() {
            return Math.max(2, Runtime.getRuntime().availableProcessors() / 3);
        }

        @Override
        public int maxNumberOfProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }

        @Override
        public int movingAverageSize() {
            return 100;
        }
    }
}

