/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class CalculateDenseNodesStep
extends ExecutorServiceStep<Pair<List<InputRelationship>, long[]>> {
    private final NodeRelationshipLink nodeRelationshipLink;
    private long highestSeenNodeId;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipLink nodeRelationshipLink) {
        super(control, "CALCULATOR", config.workAheadSize(), config.movingAverageSize(), 1);
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected Object process(long ticket, Pair<List<InputRelationship>, long[]> batch) {
        long[] startAndEndNodeIds = batch.other();
        int index = 0;
        for (InputRelationship rel : batch.first()) {
            long startNode = startAndEndNodeIds[index++];
            long endNode = startAndEndNodeIds[index++];
            this.ensureNodeFound("start", rel, startNode);
            this.ensureNodeFound("end", rel, endNode);
            try {
                this.nodeRelationshipLink.incrementCount(startNode);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("Input relationship " + rel + " refers to missing start node " + rel.startNode(), e);
            }
            if (!rel.isLoop()) {
                try {
                    this.nodeRelationshipLink.incrementCount(endNode);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Input relationship " + rel + " refers to missing end node " + rel.endNode(), e);
                }
            }
            this.highestSeenNodeId = Math.max(this.highestSeenNodeId, Math.max(startNode, endNode));
        }
        return null;
    }

    private void ensureNodeFound(String nodeDescription, InputRelationship relationship, long actualNodeId) {
        if (actualNodeId == -1L) {
            throw new InputException(relationship + " specified " + nodeDescription + " node that hasn't been imported");
        }
    }
}

