/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.log.AbstractPhysicalTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class BatchingPhysicalTransactionAppender
extends AbstractPhysicalTransactionAppender {
    AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final Lock forceLock = new ReentrantLock();

    public BatchingPhysicalTransactionAppender(LogFile logFile, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue legacyIndexTransactionOrdering, KernelHealth kernelHealth) {
        super(logFile, logRotation, transactionMetadataCache, transactionIdStore, legacyIndexTransactionOrdering, kernelHealth);
    }

    @Override
    protected void emptyBufferIntoChannel() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceAfterAppend() throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        int waitTicks = 127;
        do {
            if (this.forceLock.tryLock()) {
                try {
                    this.forceLog();
                }
                finally {
                    this.forceLock.unlock();
                    ThreadLink nextWaiter = this.threadLinkHead.get();
                    nextWaiter.unpark();
                }
            } else {
                waitTicks = this.waitForLogForce(waitTicks);
            }
        } while (!threadLink.done);
    }

    private void forceLog() throws IOException {
        ThreadLink links = this.threadLinkHead.getAndSet(ThreadLink.END);
        this.force();
        this.unparkAll(links);
    }

    private void unparkAll(ThreadLink links) {
        ThreadLink tmp;
        do {
            links.done = true;
            links.unpark();
            while ((tmp = links.next) == null) {
            }
        } while ((links = tmp) != ThreadLink.END);
    }

    private int waitForLogForce(int waitTicks) {
        waitTicks &= 0x7F;
        if (ThreadLocalRandom.current().nextBoolean()) {
            return waitTicks - 1;
        }
        long parkTime = TimeUnit.MILLISECONDS.toNanos(100L);
        LockSupport.parkNanos(this, parkTime);
        return waitTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() throws IOException {
        WritableLogChannel writableLogChannel = this.channel;
        synchronized (writableLogChannel) {
            this.channel.emptyBufferIntoChannelAndClearIt();
        }
        this.channel.force();
    }

    static class ThreadLink {
        final Thread thread;
        volatile ThreadLink next;
        volatile boolean done;
        static final ThreadLink END;

        public ThreadLink(Thread thread) {
            this.thread = thread;
        }

        public void unpark() {
            LockSupport.unpark(this.thread);
        }

        static {
            ThreadLink.END.next = END = new ThreadLink(null);
        }
    }
}

