/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.DelegatingRecordStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class StoreAccess {
    private final RecordStore<DynamicRecord> schemaStore;
    private final RecordStore<NodeRecord> nodeStore;
    private final RecordStore<RelationshipRecord> relStore;
    private final RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore;
    private final RecordStore<LabelTokenRecord> labelTokenStore;
    private final RecordStore<DynamicRecord> nodeDynamicLabelStore;
    private final RecordStore<PropertyRecord> propStore;
    private final RecordStore<DynamicRecord> stringStore;
    private final RecordStore<DynamicRecord> arrayStore;
    private final RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore;
    private final RecordStore<DynamicRecord> relationshipTypeNameStore;
    private final RecordStore<DynamicRecord> labelNameStore;
    private final RecordStore<DynamicRecord> propertyKeyNameStore;
    private final RecordStore<RelationshipGroupRecord> relGroupStore;
    private final CountsAccessor counts;
    private boolean closeable;
    private NeoStore neoStore;

    public StoreAccess(GraphDatabaseAPI graphdb) {
        this(StoreAccess.getNeoStoreFrom(graphdb));
    }

    private static NeoStore getNeoStoreFrom(GraphDatabaseAPI graphdb) {
        return (NeoStore)graphdb.getDependencyResolver().resolveDependency(NeoStoreProvider.class).evaluate();
    }

    public StoreAccess(NeoStore store) {
        this.neoStore = store;
        this.schemaStore = this.wrapStore(store.getSchemaStore());
        this.nodeStore = this.wrapStore(store.getNodeStore());
        this.relStore = this.wrapStore(store.getRelationshipStore());
        this.propStore = this.wrapStore(store.getPropertyStore());
        this.stringStore = this.wrapStore(store.getPropertyStore().getStringStore());
        this.arrayStore = this.wrapStore(store.getPropertyStore().getArrayStore());
        this.relationshipTypeTokenStore = this.wrapStore(store.getRelationshipTypeTokenStore());
        this.labelTokenStore = this.wrapStore(store.getLabelTokenStore());
        this.nodeDynamicLabelStore = this.wrapStore(StoreAccess.wrapNodeDynamicLabelStore(store.getNodeStore().getDynamicLabelStore()));
        this.propertyKeyTokenStore = this.wrapStore(store.getPropertyStore().getPropertyKeyTokenStore());
        this.relationshipTypeNameStore = this.wrapStore(store.getRelationshipTypeTokenStore().getNameStore());
        this.labelNameStore = this.wrapStore(store.getLabelTokenStore().getNameStore());
        this.propertyKeyNameStore = this.wrapStore(store.getPropertyStore().getPropertyKeyTokenStore().getNameStore());
        this.relGroupStore = this.wrapStore(store.getRelationshipGroupStore());
        this.counts = store.getCounts();
    }

    public StoreAccess(PageCache pageCache, String path) {
        this((FileSystemAbstraction)new DefaultFileSystemAbstraction(), pageCache, path);
    }

    public StoreAccess(FileSystemAbstraction fileSystem, PageCache pageCache, String path) {
        this(fileSystem, pageCache, path, new Config(StoreAccess.requiredParams(StoreAccess.defaultParams(), path)), new Monitors());
    }

    private StoreAccess(FileSystemAbstraction fileSystem, PageCache pageCache, String path, Config config, Monitors monitors) {
        this(new StoreFactory(config, new DefaultIdGeneratorFactory(), pageCache, fileSystem, StringLogger.DEV_NULL, monitors).newNeoStore(false));
        this.closeable = true;
    }

    private static Map<String, String> requiredParams(Map<String, String> params, String path) {
        return StoreFactory.configForStoreDir(new Config(), new File(path)).getParams();
    }

    public NeoStore getRawNeoStore() {
        return this.neoStore;
    }

    public RecordStore<DynamicRecord> getSchemaStore() {
        return this.schemaStore;
    }

    public RecordStore<NodeRecord> getNodeStore() {
        return this.nodeStore;
    }

    public RecordStore<RelationshipRecord> getRelationshipStore() {
        return this.relStore;
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return this.relGroupStore;
    }

    public RecordStore<PropertyRecord> getPropertyStore() {
        return this.propStore;
    }

    public RecordStore<DynamicRecord> getStringStore() {
        return this.stringStore;
    }

    public RecordStore<DynamicRecord> getArrayStore() {
        return this.arrayStore;
    }

    public RecordStore<RelationshipTypeTokenRecord> getRelationshipTypeTokenStore() {
        return this.relationshipTypeTokenStore;
    }

    public RecordStore<LabelTokenRecord> getLabelTokenStore() {
        return this.labelTokenStore;
    }

    public RecordStore<DynamicRecord> getNodeDynamicLabelStore() {
        return this.nodeDynamicLabelStore;
    }

    public RecordStore<PropertyKeyTokenRecord> getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    public RecordStore<DynamicRecord> getRelationshipTypeNameStore() {
        return this.relationshipTypeNameStore;
    }

    public RecordStore<DynamicRecord> getLabelNameStore() {
        return this.labelNameStore;
    }

    public RecordStore<DynamicRecord> getPropertyKeyNameStore() {
        return this.propertyKeyNameStore;
    }

    public CountsAccessor getCounts() {
        return this.counts;
    }

    public final <F extends Exception, P extends RecordStore.Processor<F>> P applyToAll(P processor) throws F {
        for (RecordStore<?> store : this.allStores()) {
            this.apply(processor, store);
        }
        return processor;
    }

    protected RecordStore<?>[] allStores() {
        if (this.propStore == null) {
            return new RecordStore[]{this.nodeStore, this.relStore, this.relationshipTypeTokenStore, this.relationshipTypeNameStore, this.labelTokenStore, this.labelNameStore, this.nodeDynamicLabelStore};
        }
        return new RecordStore[]{this.schemaStore, this.nodeStore, this.relStore, this.propStore, this.stringStore, this.arrayStore, this.relationshipTypeTokenStore, this.propertyKeyTokenStore, this.labelTokenStore, this.relationshipTypeNameStore, this.propertyKeyNameStore, this.labelNameStore, this.nodeDynamicLabelStore};
    }

    private static RecordStore<DynamicRecord> wrapNodeDynamicLabelStore(RecordStore<DynamicRecord> store) {
        return new DelegatingRecordStore<DynamicRecord>(store){

            @Override
            public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
                processor.processLabelArrayWithOwner(this, record);
            }
        };
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return store;
    }

    protected <FAILURE extends Exception> void apply(RecordStore.Processor<FAILURE> processor, RecordStore<?> store) throws FAILURE {
        processor.applyFiltered(store, RecordStore.IN_USE);
    }

    private static Map<String, String> defaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.pagecache_memory.name(), "50%");
        params.put(GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "true");
        return params;
    }

    public synchronized void close() {
        if (this.closeable) {
            this.closeable = false;
            this.neoStore.close();
        }
    }
}

