/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class TokenHolder<TOKEN extends Token>
extends LifecycleAdapter {
    public static final int NO_ID = -1;
    private final Map<String, Integer> nameToId = new CopyOnWriteHashMap<String, Integer>();
    private final Map<Integer, TOKEN> idToToken = new CopyOnWriteHashMap<Integer, TOKEN>();
    private final TokenCreator tokenCreator;

    public TokenHolder(TokenCreator tokenCreator) {
        this.tokenCreator = tokenCreator;
    }

    public void addTokens(Token ... tokens) throws NonUniqueTokenException {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap newIdToToken = new HashMap();
        for (Token token : tokens) {
            this.addToken(token.name(), token.id(), newNameToId, newIdToToken);
        }
        this.nameToId.putAll(newNameToId);
        this.idToToken.putAll(newIdToToken);
    }

    public void addToken(String name, int id) throws NonUniqueTokenException {
        this.addToken(name, id, this.nameToId, this.idToToken);
    }

    public void addToken(Token token) throws NonUniqueTokenException {
        this.addToken(token.name(), token.id());
    }

    void addToken(String name, int id, Map<String, Integer> nameToIdMap, Map<Integer, TOKEN> idToTokenMap) throws NonUniqueTokenException {
        TOKEN token = this.newToken(name, id);
        Integer previous = nameToIdMap.put(name, id);
        if (previous != null && previous != id) {
            throw new NonUniqueTokenException(this.getClass(), name, id, previous);
        }
        idToTokenMap.put(id, token);
    }

    public void removeToken(int id) {
        Token token = (Token)this.idToToken.remove(id);
        this.nameToId.remove(token.name());
    }

    public int getOrCreateId(String name) {
        Integer id = this.nameToId.get(name);
        if (id != null) {
            return id;
        }
        try {
            id = this.createToken(name);
            return id;
        }
        catch (Throwable e) {
            throw new TransactionFailureException("Could not create token", e);
        }
    }

    private synchronized int createToken(String name) throws KernelException {
        Integer id = this.nameToId.get(name);
        if (id != null) {
            return id;
        }
        id = this.tokenCreator.getOrCreate(name);
        try {
            this.addToken(name, id);
        }
        catch (NonUniqueTokenException e) {
            throw new IllegalStateException("Newly created token should be unique.", e);
        }
        return id;
    }

    public TOKEN getTokenById(int id) throws TokenNotFoundException {
        TOKEN result = this.getTokenByIdOrNull(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    public TOKEN getTokenByIdOrNull(int id) {
        return (TOKEN)((Token)this.idToToken.get(id));
    }

    public boolean hasTokenWithId(int id) {
        return this.idToToken.containsKey(id);
    }

    public final int idOf(TOKEN token) {
        return this.getIdByName(((Token)token).name());
    }

    public int getIdByName(String name) {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public Iterable<TOKEN> getAllTokens() {
        return this.idToToken.values();
    }

    @Override
    public void stop() {
        this.nameToId.clear();
        this.idToToken.clear();
    }

    protected abstract TOKEN newToken(String var1, int var2);
}

