/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;

public class GraphPropertiesImpl
extends Primitive
implements GraphProperties {
    private final long epoch;
    private final ThreadToStatementContextBridge statementContextProvider;
    private Map<Integer, DefinedProperty> properties;

    GraphPropertiesImpl(long epoch, ThreadToStatementContextBridge statementContextProvider) {
        this.epoch = epoch;
        this.statementContextProvider = statementContextProvider;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        throw new UnsupportedOperationException("Please implement");
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return 0;
    }

    @Override
    protected boolean hasLoadedProperties() {
        return this.properties != null;
    }

    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().graphGetProperty(propertyId).isDefined();
            return bl;
        }
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().graphGetProperty(propertyId).value();
            return object;
        }
        catch (PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                Boolean bl = false;
                return bl;
            }
            Object object = statement.readOperations().graphGetProperty(propertyId).value(defaultValue);
            return object;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            statement.dataWriteOperations().graphSetProperty(Property.property(propertyKeyId, value));
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().graphRemoveProperty(propertyId).value(null);
            return object;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.statementContextProvider.instance();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().graphGetAllProperties();
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GraphPropertiesImpl && ((GraphPropertiesImpl)obj).epoch == this.epoch;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.epoch).hashCode();
    }

    @Override
    public long getId() {
        return -1L;
    }

    @Override
    protected Iterator<DefinedProperty> getCachedProperties() {
        return this.properties.values().iterator();
    }

    @Override
    protected PrimitiveLongIterator getCachedPropertyKeys() {
        return new PropertyKeyIdIterator(this.getCachedProperties());
    }

    @Override
    protected Property getCachedProperty(int key) {
        Property property = this.properties.get(key);
        return property != null ? property : Property.noGraphProperty(key);
    }

    @Override
    protected void setProperties(Iterator<DefinedProperty> loadedProperties) {
        if (loadedProperties != null && loadedProperties.hasNext()) {
            Collection<DefinedProperty> propertiesCollection = IteratorUtil.asCollection(loadedProperties);
            DefinedProperty[] propertiesArray = propertiesCollection.toArray(new DefinedProperty[propertiesCollection.size()]);
            Arrays.sort(propertiesArray, ArrayBasedPrimitive.PROPERTY_DATA_COMPARATOR_FOR_SORTING);
            HashMap<Integer, DefinedProperty> newProperties = new HashMap<Integer, DefinedProperty>();
            for (DefinedProperty property : propertiesArray) {
                newProperties.put(property.propertyKeyId(), property);
            }
            this.properties = newProperties;
        } else {
            this.properties = new HashMap<Integer, DefinedProperty>();
        }
    }

    @Override
    public void commitPropertyMaps(PrimitiveIntObjectMap<DefinedProperty> cowPropertyAddMap, Iterator<Integer> removed) {
        if (cowPropertyAddMap != null) {
            for (int key : cowPropertyAddMap) {
                this.properties.put(key, (DefinedProperty)cowPropertyAddMap.get(key));
            }
        }
        if (removed != null) {
            while (removed.hasNext()) {
                this.properties.remove(removed.next());
            }
        }
    }
}

