/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.logging.Logging;

public class IndexProxySetup {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStoreView storeView;
    private final SchemaIndexProviderMap providerMap;
    private final UpdateableSchemaState updateableSchemaState;
    private final TokenNameLookup tokenNameLookup;
    private final JobScheduler scheduler;
    private final Logging logging;

    public IndexProxySetup(IndexSamplingConfig samplingConfig, IndexStoreView storeView, SchemaIndexProviderMap providerMap, UpdateableSchemaState updateableSchemaState, TokenNameLookup tokenNameLookup, JobScheduler scheduler, Logging logging) {
        this.samplingConfig = samplingConfig;
        this.storeView = storeView;
        this.providerMap = providerMap;
        this.updateableSchemaState = updateableSchemaState;
        this.tokenNameLookup = tokenNameLookup;
        this.scheduler = scheduler;
        this.logging = logging;
    }

    public IndexProxy createPopulatingIndexProxy(final long ruleId, final IndexDescriptor descriptor, final SchemaIndexProvider.Descriptor providerDescriptor, final boolean constraint, final IndexingService.Monitor monitor) throws IOException {
        final FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        final IndexConfiguration config = new IndexConfiguration(constraint);
        IndexPopulator populator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, config, this.samplingConfig);
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(descriptor, config, providerDescriptor, populator, indexUserDescription, IndexCountsRemover.Factory.create(this.storeView, descriptor));
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(this.scheduler, descriptor, config, failureDelegateFactory, populator, flipper, this.storeView, this.updateableSchemaState, this.logging, indexUserDescription, providerDescriptor);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(new IndexProxyFactory(){

            @Override
            public IndexProxy create() {
                try {
                    monitor.populationCompleteOn(descriptor);
                    OnlineIndexProxy onlineProxy = new OnlineIndexProxy(descriptor, config, IndexProxySetup.this.onlineAccessorFromProvider(providerDescriptor, ruleId, config, IndexProxySetup.this.samplingConfig), IndexProxySetup.this.storeView, providerDescriptor);
                    if (constraint) {
                        return new TentativeConstraintIndexProxy(flipper, onlineProxy);
                    }
                    return onlineProxy;
                }
                catch (IOException e) {
                    return IndexProxySetup.this.createFailedIndexProxy(ruleId, descriptor, providerDescriptor, constraint, IndexPopulationFailure.failure(e));
                }
            }
        });
        return new ContractCheckingIndexProxy(flipper, false);
    }

    public IndexProxy createRecoveringIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean constraint) {
        IndexConfiguration configuration = new IndexConfiguration(constraint);
        IndexProxy proxy = new RecoveringIndexProxy(descriptor, providerDescriptor, configuration);
        proxy = new ContractCheckingIndexProxy(proxy, true);
        return proxy;
    }

    public IndexProxy createOnlineIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean unique) {
        try {
            IndexConfiguration config = new IndexConfiguration(unique);
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(providerDescriptor, ruleId, config, this.samplingConfig);
            IndexProxy proxy = new OnlineIndexProxy(descriptor, config, onlineAccessor, this.storeView, providerDescriptor);
            proxy = new ContractCheckingIndexProxy(proxy, true);
            return proxy;
        }
        catch (IOException e) {
            return this.createFailedIndexProxy(ruleId, descriptor, providerDescriptor, unique, IndexPopulationFailure.failure(e));
        }
    }

    public IndexProxy createFailedIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean unique, IndexPopulationFailure populationFailure) {
        IndexConfiguration config = new IndexConfiguration(unique);
        IndexPopulator indexPopulator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, config, this.samplingConfig);
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexProxy proxy = new FailedIndexProxy(descriptor, config, providerDescriptor, indexUserDescription, indexPopulator, populationFailure, IndexCountsRemover.Factory.create(this.storeView, descriptor));
        proxy = new ContractCheckingIndexProxy(proxy, true);
        return proxy;
    }

    public String indexStateInfo(String tag, Long indexId, InternalIndexState state, IndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, indexId, this.indexUserDescription(descriptor), state.name());
    }

    public String indexUserDescription(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        return String.format("%s [provider: %s]", this.indexUserDescription(descriptor), providerDescriptor.toString());
    }

    public String indexUserDescription(IndexDescriptor descriptor) {
        return descriptor.userDescription(this.tokenNameLookup);
    }

    private IndexPopulator populatorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexDescriptor descriptor, IndexConfiguration indexConfig, IndexSamplingConfig samplingConfig) {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getPopulator(ruleId, descriptor, indexConfig, samplingConfig);
    }

    private IndexAccessor onlineAccessorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexConfiguration indexConfig, IndexSamplingConfig samplingConfig) throws IOException {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getOnlineAccessor(ruleId, indexConfig, samplingConfig);
    }
}

