/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.LogRotationImpl;
import org.neo4j.kernel.Recovery;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.GuardingStatementOperations;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogFileRecoverer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.state.CacheLoaders;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.transaction.state.RecoveryVisitor;
import org.neo4j.kernel.impl.transaction.state.RelationshipChainLoader;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class NeoStoreDataSource
implements NeoStoreProvider,
Lifecycle,
IndexProviders {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private final Monitors monitors;
    private final Monitor monitor;
    private final StringLogger msgLog;
    private final Logging logging;
    private final DependencyResolver dependencyResolver;
    private final TokenNameLookup tokenNameLookup;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokens;
    private final RelationshipTypeTokenHolder relationshipTypeTokens;
    private final Locks locks;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final StoreFactory storeFactory;
    private final JobScheduler scheduler;
    private final Config config;
    private final LockService lockService;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private final StoreUpgrader storeMigrationProcess;
    private final TransactionMonitor transactionMonitor;
    private final KernelHealth kernelHealth;
    private final PhysicalLogFile.Monitor physicalLogMonitor;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final StartupStatisticsProvider startupStatistics;
    private final Caches cacheProvider;
    private final NodeManager nodeManager;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final AtomicInteger recoveredCount = new AtomicInteger();
    private final Guard guard;
    private final Map<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();
    private final LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup;
    private final IndexConfigStore indexConfigStore;
    private Dependencies dependencies;
    private LifeSupport life;
    private SchemaIndexProvider indexProvider;
    private File storeDir;
    private boolean readOnly;
    private NeoStoreModule neoStoreModule;
    private CacheModule cacheModule;
    private IndexingModule indexingModule;
    private StoreLayerModule storeLayerModule;
    private TransactionLogModule transactionLogModule;
    private KernelModule kernelModule;

    public NeoStoreDataSource(Config config, StoreFactory sf, StringLogger stringLogger, JobScheduler scheduler, Logging logging, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, PropertyKeyTokenHolder propertyKeyTokens, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Locks lockManager, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, StoreUpgrader storeMigrationProcess, TransactionMonitor transactionMonitor, KernelHealth kernelHealth, PhysicalLogFile.Monitor physicalLogMonitor, TransactionHeaderInformationFactory transactionHeaderInformationFactory, StartupStatisticsProvider startupStatistics, Caches cacheProvider, NodeManager nodeManager, Guard guard, IndexConfigStore indexConfigStore, CommitProcessFactory commitProcessFactory, PageCache pageCache, Monitors monitors) {
        this.config = config;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.scheduler = scheduler;
        this.logging = logging;
        this.propertyKeyTokenHolder = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.locks = lockManager;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionEventHandlers = transactionEventHandlers;
        this.indexingServiceMonitor = indexingServiceMonitor;
        this.fs = fs;
        this.storeMigrationProcess = storeMigrationProcess;
        this.transactionMonitor = transactionMonitor;
        this.kernelHealth = kernelHealth;
        this.physicalLogMonitor = physicalLogMonitor;
        this.transactionHeaderInformationFactory = transactionHeaderInformationFactory;
        this.startupStatistics = startupStatistics;
        this.cacheProvider = cacheProvider;
        this.nodeManager = nodeManager;
        this.guard = guard;
        this.indexConfigStore = indexConfigStore;
        this.monitors = monitors;
        this.monitor = monitors.newMonitor(Monitor.class, new String[0]);
        this.readOnly = config.get(Configuration.read_only);
        this.msgLog = stringLogger;
        this.storeFactory = sf;
        this.lockService = new ReentrantLockService();
        this.legacyIndexProviderLookup = new LegacyIndexApplier.ProviderLookup(){

            @Override
            public IndexImplementation lookup(String name) {
                assert (name != null) : "Null provider name supplied";
                IndexImplementation provider = (IndexImplementation)NeoStoreDataSource.this.indexProviders.get(name);
                if (provider == null) {
                    throw new IllegalArgumentException("No index provider '" + name + "' found. Maybe the intended provider (or one more of its " + "dependencies) " + "aren't on the classpath or it failed to load.");
                }
                return provider;
            }

            @Override
            public Iterable<IndexImplementation> providers() {
                return NeoStoreDataSource.this.indexProviders.values();
            }
        };
        this.commitProcessFactory = commitProcessFactory;
        this.pageCache = pageCache;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws IOException {
        this.dependencies = new Dependencies();
        this.life = new LifeSupport();
        this.storeDir = this.config.get(Configuration.store_dir);
        File store = this.config.get(Configuration.neo_store);
        if (!this.storeFactory.storeExists()) {
            this.storeFactory.createNeoStore().close();
        }
        this.indexProvider = this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        LoggingLogFileMonitor loggingLogMonitor = new LoggingLogFileMonitor(this.logging.getMessagesLog(this.getClass()));
        this.monitors.addMonitorListener(loggingLogMonitor, new String[0]);
        this.monitors.addMonitorListener(new RecoveryVisitor.Monitor(){

            @Override
            public void transactionRecovered(long txId) {
                NeoStoreDataSource.this.recoveredCount.incrementAndGet();
            }
        }, new String[0]);
        this.upgradeStore(store, this.storeMigrationProcess, this.indexProvider);
        try {
            NeoStoreModule neoStoreModule;
            this.neoStoreModule = neoStoreModule = this.buildNeoStore(this.storeFactory, this.labelTokens, this.relationshipTypeTokens, this.propertyKeyTokenHolder);
            CacheModule cacheModule = this.buildCaches(neoStoreModule.neoStore(), this.cacheProvider, this.nodeManager, this.labelTokens, this.relationshipTypeTokens, this.propertyKeyTokenHolder);
            IndexingModule indexingModule = this.buildIndexing(this.config, this.scheduler, this.indexProvider, this.lockService, this.tokenNameLookup, this.logging, this.indexingServiceMonitor, neoStoreModule.neoStore(), cacheModule.updateableSchemaState());
            StoreLayerModule storeLayerModule = this.buildStoreLayer(this.config, neoStoreModule.neoStore(), cacheModule.persistenceCache(), this.propertyKeyTokenHolder, this.labelTokens, this.relationshipTypeTokens, indexingModule.indexingService(), cacheModule.schemaCache());
            TransactionLogModule transactionLogModule = this.buildTransactionLogs(this.config, this.logging, indexingModule.labelScanStore(), this.fs, neoStoreModule.neoStore(), cacheModule.cacheAccess(), indexingModule.indexingService(), this.indexProviders.values());
            this.buildRecovery(this.fs, cacheModule.cacheAccess(), indexingModule.indexingService(), indexingModule.labelScanStore(), neoStoreModule.neoStore(), this.monitors.newMonitor(RecoveryVisitor.Monitor.class, new String[0]), this.monitors.newMonitor(Recovery.Monitor.class, new String[0]), transactionLogModule.logFiles(), transactionLogModule.logRotationControl(), this.startupStatistics);
            KernelModule kernelModule = this.buildKernel(indexingModule.integrityValidator(), transactionLogModule.logicalTransactionStore(), neoStoreModule.neoStore(), transactionLogModule.storeApplier(), indexingModule.indexingService(), storeLayerModule.storeLayer(), cacheModule.updateableSchemaState(), indexingModule.labelScanStore(), cacheModule.persistenceCache(), indexingModule.schemaIndexProviderMap());
            this.cacheModule = cacheModule;
            this.indexingModule = indexingModule;
            this.storeLayerModule = storeLayerModule;
            this.transactionLogModule = transactionLogModule;
            this.kernelModule = kernelModule;
            this.dependencies.satisfyDependency(this);
            this.satisfyDependencies(neoStoreModule, cacheModule, indexingModule, storeLayerModule, transactionLogModule, kernelModule);
        }
        catch (Throwable e) {
            try {
                this.neoStoreModule.neoStore().close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
        try {
            this.life.start();
        }
        catch (Throwable e) {
            try {
                this.neoStoreModule.neoStore().close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
    }

    private void upgradeStore(File store, StoreUpgrader storeMigrationProcess, SchemaIndexProvider indexProvider) {
        storeMigrationProcess.addParticipant(indexProvider.storeMigrationParticipant());
        storeMigrationProcess.migrateIfNeeded(store.getParentFile(), indexProvider, this.pageCache);
    }

    private NeoStoreModule buildNeoStore(final StoreFactory storeFactory, final LabelTokenHolder labelTokens, final RelationshipTypeTokenHolder relationshipTypeTokens, final PropertyKeyTokenHolder propertyKeyTokenHolder) {
        final NeoStore neoStore = storeFactory.newNeoStore(false);
        this.life.add(new LifecycleAdapter(){

            @Override
            public void start() {
                if (NeoStoreDataSource.this.startupStatistics.numberOfRecoveredTransactions() > 0) {
                    neoStore.rebuildIdGenerators();
                }
                NeoStoreDataSource.this.neoStoreModule.neoStore().makeStoreOk();
                propertyKeyTokenHolder.addTokens(NeoStoreDataSource.this.neoStoreModule.neoStore().getPropertyKeyTokenStore().getTokens(Integer.MAX_VALUE));
                relationshipTypeTokens.addTokens(NeoStoreDataSource.this.neoStoreModule.neoStore().getRelationshipTypeTokenStore().getTokens(Integer.MAX_VALUE));
                labelTokens.addTokens(NeoStoreDataSource.this.neoStoreModule.neoStore().getLabelTokenStore().getTokens(Integer.MAX_VALUE));
                if (neoStore.getCounts() == null) {
                    neoStore.rebuildCountStoreIfNeeded(storeFactory.storeFileName(".counts.db"));
                }
            }
        });
        return new NeoStoreModule(){

            @Override
            public NeoStore neoStore() {
                return neoStore;
            }
        };
    }

    private CacheModule buildCaches(NeoStore neoStore, Caches cacheProvider, NodeManager nodeManager, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, PropertyKeyTokenHolder propertyKeyTokenHolder) {
        final KernelSchemaStateStore updateableSchemaState = new KernelSchemaStateStore(this.logging.getMessagesLog(KernelSchemaStateStore.class));
        final SchemaCache schemaCache = new SchemaCache(Collections.emptyList());
        final AutoLoadingCache<NodeImpl> nodeCache = new AutoLoadingCache<NodeImpl>(cacheProvider.node(), CacheLoaders.nodeLoader(neoStore.getNodeStore()));
        final AutoLoadingCache<RelationshipImpl> relationshipCache = new AutoLoadingCache<RelationshipImpl>(cacheProvider.relationship(), CacheLoaders.relationshipLoader(neoStore.getRelationshipStore()));
        RelationshipLoader relationshipLoader = new RelationshipLoader(this.lockService, relationshipCache, new RelationshipChainLoader(neoStore));
        final PersistenceCache persistenceCache = new PersistenceCache(nodeCache, relationshipCache, nodeManager, relationshipLoader, propertyKeyTokenHolder, relationshipTypeTokens, labelTokens);
        final BridgingCacheAccess cacheAccess = new BridgingCacheAccess(schemaCache, updateableSchemaState, persistenceCache);
        this.life.add(new LifecycleAdapter(){

            @Override
            public void start() throws Throwable {
                NeoStoreDataSource.this.loadSchemaCache();
            }

            @Override
            public void stop() throws Throwable {
            }
        });
        return new CacheModule(){

            @Override
            public SchemaCache schemaCache() {
                return schemaCache;
            }

            @Override
            public UpdateableSchemaState updateableSchemaState() {
                return updateableSchemaState;
            }

            @Override
            public PersistenceCache persistenceCache() {
                return persistenceCache;
            }

            @Override
            public CacheAccessBackDoor cacheAccess() {
                return cacheAccess;
            }

            @Override
            public Cache<NodeImpl> nodeCache() {
                return nodeCache;
            }

            @Override
            public Cache<RelationshipImpl> relationshipCache() {
                return relationshipCache;
            }
        };
    }

    private IndexingModule buildIndexing(Config config, JobScheduler scheduler, SchemaIndexProvider indexProvider, LockService lockService, TokenNameLookup tokenNameLookup, Logging logging, IndexingService.Monitor indexingServiceMonitor, NeoStore neoStore, UpdateableSchemaState updateableSchemaState) {
        final DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(indexProvider);
        final IndexingService indexingService = IndexingService.create(new IndexSamplingConfig(config), scheduler, providerMap, new NeoStoreIndexStoreView(lockService, neoStore), tokenNameLookup, updateableSchemaState, Iterables.toList(new SchemaStorage(neoStore.getSchemaStore()).allIndexRules()), logging, indexingServiceMonitor);
        final IntegrityValidator integrityValidator = new IntegrityValidator(neoStore, indexingService);
        final LabelScanStore labelScanStore = this.dependencyResolver.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore();
        this.life.add(indexingService);
        this.life.add(labelScanStore);
        return new IndexingModule(){

            @Override
            public IndexingService indexingService() {
                return indexingService;
            }

            @Override
            public LabelScanStore labelScanStore() {
                return labelScanStore;
            }

            @Override
            public IntegrityValidator integrityValidator() {
                return integrityValidator;
            }

            @Override
            public SchemaIndexProviderMap schemaIndexProviderMap() {
                return providerMap;
            }
        };
    }

    private StoreLayerModule buildStoreLayer(Config config, NeoStore neoStore, PersistenceCache persistenceCache, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, IndexingService indexingService, SchemaCache schemaCache) {
        Provider<NeoStore> neoStoreProvider = new Provider<NeoStore>(){

            @Override
            public NeoStore instance() {
                return NeoStoreDataSource.this.neoStoreModule.neoStore();
            }
        };
        final StoreReadLayer storeLayer = config.get(GraphDatabaseSettings.cache_type).equals("experimental-off") ? new DiskLayer(propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, new SchemaStorage(neoStore.getSchemaStore()), neoStoreProvider, indexingService) : new CacheLayer(new DiskLayer(propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, new SchemaStorage(neoStore.getSchemaStore()), neoStoreProvider, indexingService), persistenceCache, indexingService, schemaCache);
        return new StoreLayerModule(){

            @Override
            public StoreReadLayer storeLayer() {
                return storeLayer;
            }
        };
    }

    private TransactionLogModule buildTransactionLogs(Config config, Logging logging, LabelScanStore labelScanStore, FileSystemAbstraction fileSystemAbstraction, NeoStore neoStore, CacheAccessBackDoor cacheAccess, IndexingService indexingService, Iterable<IndexImplementation> indexProviders) {
        File directory = config.get(GraphDatabaseSettings.store_dir);
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(1000, 100000);
        final PhysicalLogFiles logFiles = new PhysicalLogFiles(directory, "neostore.transaction.db", fileSystemAbstraction);
        SynchronizedArrayIdOrderingQueue legacyIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
        final TransactionRepresentationStoreApplier storeApplier = this.dependencies.satisfyDependency(new TransactionRepresentationStoreApplier(indexingService, labelScanStore, neoStore, cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, legacyIndexTransactionOrdering));
        final PhysicalLogFile logFile = new PhysicalLogFile(fileSystemAbstraction, logFiles, config.get(GraphDatabaseSettings.logical_log_rotation_threshold), neoStore, neoStore, this.physicalLogMonitor, transactionMetadataCache);
        PhysicalLogFileInformation.SPI logInformation = new PhysicalLogFileInformation.SPI(){

            @Override
            public long getTimestampForVersion(long version) throws IOException {
                LogPosition position = new LogPosition(version, 16L);
                try (ReadableVersionableLogChannel channel = logFile.getReader(position);){
                    LogEntry entry;
                    LogEntryReader reader = new LogEntryReaderFactory().versionable();
                    while ((entry = reader.readLogEntry(channel)) != null) {
                        if (!(entry instanceof LogEntryStart)) continue;
                        long l = ((LogEntryStart)entry.as()).getTimeWritten();
                        return l;
                    }
                }
                return -1L;
            }
        };
        final PhysicalLogFileInformation logFileInformation = new PhysicalLogFileInformation(logFiles, transactionMetadataCache, neoStore, logInformation);
        LogPruneStrategy logPruneStrategy = LogPruneStrategyFactory.fromConfigValue(this.fs, logFileInformation, logFiles, neoStore, config.get(GraphDatabaseSettings.keep_logical_logs));
        this.monitors.addMonitorListener(new LogPruning(logPruneStrategy, logging), new String[0]);
        final LogRotationControl logRotationControl = new LogRotationControl(neoStore, indexingService, labelScanStore, indexProviders);
        final LogRotationImpl logRotation = new LogRotationImpl(this.monitors.newMonitor(LogRotation.Monitor.class, new String[0]), logFile, logRotationControl, this.kernelHealth, logging);
        final PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFile, logRotation, transactionMetadataCache, neoStore, legacyIndexTransactionOrdering, this.kernelHealth, config.get(GraphDatabaseSettings.batched_writes));
        this.life.add(logFile);
        this.life.add(logicalTransactionStore);
        return new TransactionLogModule(){

            @Override
            public TransactionRepresentationStoreApplier storeApplier() {
                return storeApplier;
            }

            @Override
            public LogicalTransactionStore logicalTransactionStore() {
                return logicalTransactionStore;
            }

            @Override
            public LogFileInformation logFileInformation() {
                return logFileInformation;
            }

            @Override
            public PhysicalLogFiles logFiles() {
                return logFiles;
            }

            @Override
            public LogFile logFile() {
                return logFile;
            }

            @Override
            public LogRotationControl logRotationControl() {
                return logRotationControl;
            }

            @Override
            public LogRotation logRotation() {
                return logRotation;
            }
        };
    }

    private void buildRecovery(final FileSystemAbstraction fileSystemAbstraction, CacheAccessBackDoor cacheAccess, IndexingService indexingService, LabelScanStore labelScanStore, final NeoStore neoStore, RecoveryVisitor.Monitor recoveryVisitorMonitor, Recovery.Monitor recoveryMonitor, final PhysicalLogFiles logFiles, final LogRotationControl logRotationControl, final StartupStatisticsProvider startupStatistics) {
        TransactionRepresentationStoreApplier storeRecoverer = new TransactionRepresentationStoreApplier(indexingService, labelScanStore, neoStore, cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, IdOrderingQueue.BYPASS);
        RecoveryVisitor recoveryVisitor = new RecoveryVisitor(neoStore, storeRecoverer, recoveryVisitorMonitor);
        LogEntryReader<ReadableVersionableLogChannel> logEntryReader = new LogEntryReaderFactory().versionable();
        final LogFileRecoverer logFileRecoverer = new LogFileRecoverer(logEntryReader, recoveryVisitor);
        Recovery recovery = new Recovery(new Recovery.SPI(){

            @Override
            public void forceEverything() {
                logRotationControl.forceEverything();
            }

            @Override
            public long getCurrentLogVersion() {
                return neoStore.getCurrentLogVersion();
            }

            @Override
            public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
                return logFileRecoverer;
            }

            @Override
            public PhysicalLogVersionedStoreChannel getLogFile(long recoveryVersion) throws IOException {
                return PhysicalLogFile.openForVersion(logFiles, fileSystemAbstraction, recoveryVersion);
            }
        }, recoveryMonitor);
        this.life.add(recovery);
        this.life.add(new LifecycleAdapter(){

            @Override
            public void start() throws Throwable {
                startupStatistics.setNumberOfRecoveredTransactions(NeoStoreDataSource.this.recoveredCount.get());
                NeoStoreDataSource.this.recoveredCount.set(0);
            }
        });
    }

    private KernelModule buildKernel(IntegrityValidator integrityValidator, LogicalTransactionStore logicalTransactionStore, NeoStore neoStore, TransactionRepresentationStoreApplier storeApplier, IndexingService indexingService, StoreReadLayer storeLayer, UpdateableSchemaState updateableSchemaState, LabelScanStore labelScanStore, PersistenceCache persistenceCache, SchemaIndexProviderMap schemaIndexProviderMap) {
        final TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(logicalTransactionStore, this.kernelHealth, neoStore, storeApplier, new NeoStoreInjectedTransactionValidator(integrityValidator), TransactionApplicationMode.INTERNAL, this.config);
        Provider<KernelAPI> kernelProvider = new Provider<KernelAPI>(){

            @Override
            public KernelAPI instance() {
                return NeoStoreDataSource.this.kernelModule.kernelAPI();
            }
        };
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService);
        LegacyIndexStore legacyIndexStore = new LegacyIndexStore(this.config, this.indexConfigStore, kernelProvider, this.legacyIndexProviderLookup);
        LegacyPropertyTrackers legacyPropertyTrackers = new LegacyPropertyTrackers(this.propertyKeyTokenHolder, this.nodeManager.getNodePropertyTrackers(), this.nodeManager.getRelationshipPropertyTrackers(), this.nodeManager);
        NeoStoreTransactionContextSupplier neoStoreTransactionContextSupplier = new NeoStoreTransactionContextSupplier(neoStore);
        StatementOperationParts statementOperations = this.buildStatementOperations(storeLayer, legacyPropertyTrackers, constraintIndexCreator, updateableSchemaState, this.guard, legacyIndexStore);
        TransactionHooks hooks = new TransactionHooks();
        final KernelTransactions kernelTransactions = this.life.add(new KernelTransactions(neoStoreTransactionContextSupplier, neoStore, this.locks, integrityValidator, constraintIndexCreator, indexingService, labelScanStore, statementOperations, updateableSchemaState, this.schemaWriteGuard, schemaIndexProviderMap, this.transactionHeaderInformationFactory, persistenceCache, storeLayer, transactionCommitProcess, this.indexConfigStore, this.legacyIndexProviderLookup, hooks, this.transactionMonitor, this.life));
        final Kernel kernel = new Kernel(kernelTransactions, hooks, this.kernelHealth, this.transactionMonitor);
        kernel.registerTransactionHook(this.transactionEventHandlers);
        final NeoStoreFileListing fileListing = new NeoStoreFileListing(this.storeDir, labelScanStore, indexingService, this.legacyIndexProviderLookup);
        return new KernelModule(){

            @Override
            public TransactionCommitProcess transactionCommitProcess() {
                return transactionCommitProcess;
            }

            @Override
            public KernelAPI kernelAPI() {
                return kernel;
            }

            @Override
            public KernelTransactions kernelTransactions() {
                return kernelTransactions;
            }

            @Override
            public NeoStoreFileListing fileListing() {
                return fileListing;
            }
        };
    }

    private void satisfyDependencies(Object ... modules) {
        for (Object module : modules) {
            for (Method method : module.getClass().getMethods()) {
                if (method.getDeclaringClass().equals(Object.class)) continue;
                try {
                    this.dependencies.satisfyDependency(method.invoke(module, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void loadSchemaCache() {
        this.cacheModule.schemaCache().load(this.neoStoreModule.neoStore().getSchemaStore().loadAllSchemaRules());
    }

    public NeoStore getNeoStore() {
        return this.neoStoreModule.neoStore();
    }

    public IndexingService getIndexService() {
        return this.indexingModule.indexingService();
    }

    public SchemaIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public LabelScanStore getLabelScanStore() {
        return this.indexingModule.labelScanStore();
    }

    public LockService getLockService() {
        return this.lockService;
    }

    @Override
    public void stop() {
        this.transactionLogModule.logRotationControl().awaitAllTransactionsClosed();
        this.transactionLogModule.logRotationControl().forceEverything();
        this.neoStoreModule.neoStore().incrementAndGetVersion();
        this.life.shutdown();
        this.neoStoreModule.neoStore().close();
        this.msgLog.info("NeoStore closed");
    }

    @Override
    public void shutdown() {
    }

    public StoreId getStoreId() {
        return this.getNeoStore().getStoreId();
    }

    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    public long getCreationTime() {
        return this.getNeoStore().getCreationTime();
    }

    public long getRandomIdentifier() {
        return this.getNeoStore().getRandomNumber();
    }

    public long getCurrentLogVersion() {
        return this.getNeoStore().getCurrentLogVersion();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public KernelAPI getKernel() {
        return this.kernelModule.kernelAPI();
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.kernelModule.fileListing().listStoreFiles();
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    @Override
    public NeoStore evaluate() {
        return this.neoStoreModule.neoStore();
    }

    public StoreReadLayer getStoreLayer() {
        return this.storeLayerModule.storeLayer();
    }

    public void awaitAllTransactionsClosed() {
        while (!this.neoStoreModule.neoStore().closedTransactionIdIsOnParWithCommittedTransactionId()) {
            LockSupport.parkNanos(1000000L);
        }
    }

    public Cache<NodeImpl> getNodeCache() {
        return this.cacheModule.nodeCache();
    }

    public Cache<RelationshipImpl> getRelationshipCache() {
        return this.cacheModule.relationshipCache();
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    private StatementOperationParts buildStatementOperations(StoreReadLayer storeReadLayer, LegacyPropertyTrackers legacyPropertyTrackers, ConstraintIndexCreator constraintIndexCreator, UpdateableSchemaState updateableSchemaState, Guard guard, LegacyIndexStore legacyIndexStore) {
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(storeReadLayer, legacyPropertyTrackers, constraintIndexCreator, legacyIndexStore);
        StatementOperationParts parts = new StatementOperationParts(stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(updateableSchemaState), null, stateHandlingContext, stateHandlingContext, stateHandlingContext);
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations());
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, null, null, null, null);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityReadOperations(), parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, lockingContext, null, null, null);
        if (guard != null) {
            GuardingStatementOperations guardingOperations = new GuardingStatementOperations(parts.entityWriteOperations(), parts.entityReadOperations(), guard);
            parts = parts.override(null, null, guardingOperations, guardingOperations, null, null, null, null, null, null, null);
        }
        return parts;
    }

    @Override
    public void registerIndexProvider(String name, IndexImplementation index) {
        assert (!this.indexProviders.containsKey(name)) : "Index provider '" + name + "' already registered";
        this.indexProviders.put(name, index);
    }

    @Override
    public boolean unregisterIndexProvider(String name) {
        IndexImplementation removed = this.indexProviders.remove(name);
        return removed != null;
    }

    public void afterModeSwitch() {
        this.loadSchemaCache();
        this.kernelModule.kernelTransactions().disposeAll();
    }

    public static abstract class Configuration {
        public static final Setting<String> keep_logical_logs = GraphDatabaseSettings.keep_logical_logs;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
    }

    private static enum Diagnostics implements DiagnosticsExtractor<NeoStoreDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreDataSource source, StringLogger.LineLogger log) {
                source.neoStoreModule.neoStore().logVersions(log);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreDataSource source, StringLogger.LineLogger log) {
                source.neoStoreModule.neoStore().logIdUsage(log);
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(final NeoStoreDataSource source, DiagnosticsPhase phase, StringLogger log) {
            if (this.applicable(phase)) {
                log.logLongMessage(this.message, new Visitor<StringLogger.LineLogger, RuntimeException>(){

                    @Override
                    public boolean visit(StringLogger.LineLogger logger) {
                        Diagnostics.this.dump(source, logger);
                        return false;
                    }
                }, true);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreDataSource var1, StringLogger.LineLogger var2);
    }

    private static interface KernelModule {
        public TransactionCommitProcess transactionCommitProcess();

        public KernelTransactions kernelTransactions();

        public KernelAPI kernelAPI();

        public NeoStoreFileListing fileListing();
    }

    private static interface TransactionLogModule {
        public TransactionRepresentationStoreApplier storeApplier();

        public LogicalTransactionStore logicalTransactionStore();

        public PhysicalLogFiles logFiles();

        public LogFileInformation logFileInformation();

        public LogFile logFile();

        public LogRotationControl logRotationControl();

        public LogRotation logRotation();
    }

    private static interface StoreLayerModule {
        public StoreReadLayer storeLayer();
    }

    private static interface IndexingModule {
        public IndexingService indexingService();

        public LabelScanStore labelScanStore();

        public IntegrityValidator integrityValidator();

        public SchemaIndexProviderMap schemaIndexProviderMap();
    }

    private static interface CacheModule {
        public UpdateableSchemaState updateableSchemaState();

        public PersistenceCache persistenceCache();

        public CacheAccessBackDoor cacheAccess();

        public SchemaCache schemaCache();

        public Cache<NodeImpl> nodeCache();

        public Cache<RelationshipImpl> relationshipCache();
    }

    private static interface NeoStoreModule {
        public NeoStore neoStore();
    }

    public static interface Monitor {
        public void rotatedLog();

        public static class Adapter
        implements Monitor {
            @Override
            public void rotatedLog() {
            }
        }
    }
}

