/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.helpers.Clock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class DatabaseAvailability
implements Lifecycle,
AvailabilityGuard.AvailabilityRequirement {
    private final AvailabilityGuard availabilityGuard;
    private final TransactionCounters transactionMonitor;

    public DatabaseAvailability(AvailabilityGuard availabilityGuard, TransactionCounters transactionMonitor) {
        this.availabilityGuard = availabilityGuard;
        this.transactionMonitor = transactionMonitor;
        availabilityGuard.deny(this);
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
        this.availabilityGuard.grant(this);
    }

    @Override
    public void stop() throws Throwable {
        this.availabilityGuard.deny(this);
        this.awaitNoTransactionsOr(10000);
    }

    private void awaitNoTransactionsOr(int orUntilDeadline) {
        long deadline = Clock.SYSTEM_CLOCK.currentTimeMillis() + (long)orUntilDeadline;
        while (this.transactionMonitor.getNumberOfActiveTransactions() > 0L && Clock.SYSTEM_CLOCK.currentTimeMillis() < deadline) {
            Thread.yield();
        }
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public String description() {
        return "Database is stopped";
    }
}

