/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.unsafe.impl.batchimport.store.BatchingRecordAccess;

public abstract class BatchingTokenRepository<T extends TokenRecord> {
    private final Map<String, Integer> existing = new HashMap<String, Integer>();
    private final Map<String, Integer> created = new HashMap<String, Integer>();
    private final TokenStore<T> store;
    private int highId;

    public BatchingTokenRepository(TokenStore<T> store, int highId) {
        this.store = store;
        this.highId = highId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name) {
        assert (name != null);
        Integer id = this.existing.get(name);
        if (id == null) {
            Map<String, Integer> map = this.created;
            synchronized (map) {
                id = this.created.get(name);
                if (id == null) {
                    id = this.highId++;
                    this.created.put(name, id);
                }
            }
        }
        return id;
    }

    public long[] getOrCreateIds(String[] labels) {
        int from;
        long[] result = new long[labels.length];
        int to = 0;
        for (from = 0; from < labels.length; ++from) {
            int id = this.getOrCreateId(labels[from]);
            if (this.contains(result, id, to)) continue;
            result[to++] = id;
        }
        if (to < from) {
            result = Arrays.copyOf(result, to);
        }
        Arrays.sort(result);
        return result;
    }

    private boolean contains(long[] array, long id, int arrayLength) {
        for (int i = 0; i < arrayLength; ++i) {
            if (array[i] != id) continue;
            return true;
        }
        return false;
    }

    public int getHighId() {
        return this.highId;
    }

    protected abstract T createRecord(int var1);

    public void close() {
        BatchingRecordAccess recordAccess = new BatchingRecordAccess<Integer, T, Void>(){

            @Override
            protected T createRecord(Integer key, Void additionalData) {
                return BatchingTokenRepository.this.createRecord(key);
            }
        };
        TokenCreator<T> creator = new TokenCreator<T>(this.store);
        int highest = 1;
        for (Map.Entry<Integer, String> tokenToCreate : this.sortCreatedTokensById()) {
            creator.createToken(tokenToCreate.getValue(), tokenToCreate.getKey(), recordAccess);
            highest = Math.max(highest, tokenToCreate.getKey());
        }
        int highestId = (int)this.store.getHighestPossibleIdInUse();
        for (TokenRecord record : recordAccess.records()) {
            this.store.updateRecord(record);
            highestId = Math.max(highestId, record.getId());
        }
        this.store.setHighestPossibleIdInUse(highestId);
    }

    private Iterable<Map.Entry<Integer, String>> sortCreatedTokensById() {
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : this.created.entrySet()) {
            sorted.put(entry.getValue(), entry.getKey());
        }
        return sorted.entrySet();
    }

    public static class BatchingRelationshipTypeTokenRepository
    extends BatchingTokenRepository<RelationshipTypeTokenRecord> {
        public BatchingRelationshipTypeTokenRepository(TokenStore<RelationshipTypeTokenRecord> store, int highId) {
            super(store, highId);
        }

        @Override
        protected RelationshipTypeTokenRecord createRecord(int key) {
            return new RelationshipTypeTokenRecord(key);
        }
    }

    public static class BatchingLabelTokenRepository
    extends BatchingTokenRepository<LabelTokenRecord> {
        public BatchingLabelTokenRepository(TokenStore<LabelTokenRecord> store, int highId) {
            super(store, highId);
        }

        @Override
        protected LabelTokenRecord createRecord(int key) {
            return new LabelTokenRecord(key);
        }
    }

    public static class BatchingPropertyKeyTokenRepository
    extends BatchingTokenRepository<PropertyKeyTokenRecord> {
        public BatchingPropertyKeyTokenRepository(TokenStore<PropertyKeyTokenRecord> store, int highId) {
            super(store, highId);
        }

        @Override
        protected PropertyKeyTokenRecord createRecord(int key) {
            return new PropertyKeyTokenRecord(key);
        }
    }
}

