/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Collection;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class StageExecution
implements StageControl {
    private final String stageName;
    private final Configuration config;
    private final Collection<Step<?>> pipeline;
    private volatile Throwable panicCause;
    private long startTime;

    public StageExecution(String stageName, Configuration config, Collection<Step<?>> pipeline) {
        this.stageName = stageName;
        this.config = config;
        this.pipeline = pipeline;
    }

    public boolean stillExecuting() {
        Throwable panic = this.panicCause;
        if (panic != null) {
            String message = panic.getMessage();
            throw new RuntimeException(message == null ? "Panic" : message, panic);
        }
        for (Step<?> step : this.pipeline) {
            if (step.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long getExecutionTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getStageName() {
        return this.stageName;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Iterable<StepStats> stats() {
        return new IterableWrapper<StepStats, Step<?>>(this.pipeline){

            @Override
            protected StepStats underlyingObjectToObject(Step<?> step) {
                return step.stats();
            }
        };
    }

    public int size() {
        return this.pipeline.size();
    }

    @Override
    public void panic(Throwable cause) {
        this.panicCause = cause;
        for (Step<?> step : this.pipeline) {
            step.receivePanic(cause);
        }
    }
}

