/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.staging.PollingExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.QuantizedProjection;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class SpectrumExecutionMonitor
extends PollingExecutionMonitor {
    public static final int DEFAULT_WIDTH = 80;
    private static final char[] WEIGHTS = new char[]{' ', 'k', 'M', 'B', 'T'};
    private final PrintStream out;
    private final int width;

    public SpectrumExecutionMonitor(long interval, TimeUnit unit, PrintStream out, int width) {
        super(interval, unit);
        this.out = out;
        this.width = width;
    }

    @Override
    protected void start(StageExecution[] executions) {
        for (int i = 0; i < executions.length; ++i) {
            if (i > 0) {
                this.out.print(", ");
            }
            this.out.print(executions[i].getStageName());
        }
        this.out.println();
    }

    @Override
    protected void end(StageExecution[] executions, long totalTimeMillis) {
        this.out.println();
    }

    @Override
    protected void poll(StageExecution[] executions) {
        int active = this.countActive(executions);
        float partWidth = (float)this.width / (float)active;
        StringBuilder builder = new StringBuilder();
        boolean allPrinted = true;
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            allPrinted &= this.printSpectrum(builder, execution, Math.round(partWidth));
        }
        if (allPrinted) {
            this.out.print("\r" + builder);
        }
    }

    private int countActive(StageExecution[] executions) {
        int active = 0;
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            ++active;
        }
        return active;
    }

    private boolean printSpectrum(StringBuilder builder, StageExecution execution, int width) {
        long[] values = this.values(execution);
        long total = this.total(values);
        if (total == 0L) {
            return false;
        }
        QuantizedProjection projection = new QuantizedProjection(total, width -= values.length + 1 + 4);
        long lastDoneBatches = 0L;
        int stepIndex = 0;
        for (StepStats step : execution.stats()) {
            if (!projection.next(this.avg(step))) {
                throw new IllegalStateException();
            }
            long stepWidth = projection.step();
            String name = step.toString(DetailLevel.IMPORTANT);
            builder.append(stepIndex++ == 0 ? (char)'[' : '|');
            int charIndex = 0;
            char backgroundChar = '-';
            int i = 0;
            while ((long)i < stepWidth) {
                char ch = backgroundChar;
                if (charIndex >= 0 && charIndex < name.length() && (long)charIndex < stepWidth) {
                    ch = name.charAt(charIndex);
                }
                builder.append(ch);
                ++i;
                ++charIndex;
            }
            lastDoneBatches = step.stat(Keys.done_batches).asLong();
        }
        long progress = lastDoneBatches * (long)execution.getConfig().batchSize();
        builder.append("]").append(SpectrumExecutionMonitor.fitInFour(progress));
        return true;
    }

    private static String fitInFour(long value) {
        int weight = SpectrumExecutionMonitor.weight(value);
        String result = weight == 0 ? String.valueOf(value) : String.format("%d%s", (long)((double)value / Math.pow(1000.0, weight)), Character.valueOf(WEIGHTS[weight]));
        return SpectrumExecutionMonitor.pad(result, 4, ' ');
    }

    private static String pad(String result, int length, char padChar) {
        while (result.length() < length) {
            result = padChar + result;
        }
        return result;
    }

    private static int weight(long value) {
        int weight = 0;
        while (value >= 1000L) {
            value /= 1000L;
            ++weight;
        }
        return weight;
    }

    private long[] values(StageExecution execution) {
        long[] values = new long[execution.size()];
        int i = 0;
        for (StepStats stats : execution.stats()) {
            values[i++] = this.avg(stats);
        }
        return values;
    }

    private long total(long[] values) {
        long total = 0L;
        for (long value : values) {
            total += value;
        }
        return total;
    }

    private long avg(StatsProvider step) {
        return step.stat(Keys.avg_processing_time).asLong();
    }

    @Override
    public void done(long totalTimeMillis) {
        this.out.println();
        this.out.println("IMPORT DONE. Took: " + Format.duration(totalTimeMillis));
    }
}

