/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class ProducerStep<T>
extends AbstractStep<Void> {
    private final int batchSize;

    public ProducerStep(StageControl control, String name, int batchSize) {
        super(control, name);
        this.batchSize = batchSize;
    }

    protected abstract T nextOrNull();

    @Override
    public long receive(long ticket, Void nothing) {
        new Thread("PRODUCER"){

            @Override
            public void run() {
                ProducerStep.this.assertHealthy();
                try {
                    ProducerStep.this.process();
                    ProducerStep.this.endOfUpstream();
                }
                catch (Throwable e) {
                    ProducerStep.this.issuePanic(e, false);
                }
            }
        }.start();
        return 0L;
    }

    protected void process() {
        ArrayList<Object> batch = new ArrayList<Object>(this.batchSize);
        int size = 0;
        long startTime = System.currentTimeMillis();
        Object next = null;
        while (true) {
            T t = this.nextOrNull();
            next = t;
            if (t == null) break;
            batch.add(next);
            if (++size != this.batchSize) continue;
            this.totalProcessingTime.addAndGet(System.currentTimeMillis() - startTime);
            this.sendDownstream(this.nextTicket(), batch);
            batch = new ArrayList(this.batchSize);
            size = 0;
            this.assertHealthy();
            startTime = System.currentTimeMillis();
        }
        if (size > 0) {
            this.totalProcessingTime.addAndGet(System.currentTimeMillis() - startTime);
            this.sendDownstream(this.nextTicket(), batch);
        }
    }

    private long nextTicket() {
        return this.doneBatches.incrementAndGet();
    }
}

