/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.function.Function;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapping;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputRelationshipDeserializer;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class CsvInput
implements Input {
    private final Iterable<DataFactory<InputNode>> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory<InputRelationship>> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final IdType idType;
    private final IdMapping idMapping;
    private final Configuration config;
    private final int[] delimiter;
    private final BatchingIdSequence relationshipIds = new BatchingIdSequence();

    public CsvInput(Iterable<DataFactory<InputNode>> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory<InputRelationship>> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config) {
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.idType = idType;
        this.idMapping = idType.idMapping();
        this.config = config;
        this.delimiter = new int[]{config.delimiter()};
    }

    @Override
    public ResourceIterable<InputNode> nodes() {
        return new ResourceIterable<InputNode>(){

            @Override
            public ResourceIterator<InputNode> iterator() {
                return new InputGroupsDeserializer<InputNode>(CsvInput.this.nodeDataFactory.iterator(), CsvInput.this.nodeHeaderFactory, CsvInput.this.config, CsvInput.this.idType){

                    @Override
                    protected ResourceIterator<InputNode> entityDeserializer(CharSeeker dataStream, Header dataHeader, Function<InputNode, InputNode> decorator) {
                        return new InputNodeDeserializer(dataHeader, dataStream, CsvInput.this.delimiter, decorator);
                    }
                };
            }
        };
    }

    @Override
    public ResourceIterable<InputRelationship> relationships() {
        return new ResourceIterable<InputRelationship>(){

            @Override
            public ResourceIterator<InputRelationship> iterator() {
                CsvInput.this.relationshipIds.reset();
                return new InputGroupsDeserializer<InputRelationship>(CsvInput.this.relationshipDataFactory.iterator(), CsvInput.this.relationshipHeaderFactory, CsvInput.this.config, CsvInput.this.idType){

                    @Override
                    protected ResourceIterator<InputRelationship> entityDeserializer(CharSeeker dataStream, Header dataHeader, Function<InputRelationship, InputRelationship> decorator) {
                        return new InputRelationshipDeserializer(dataHeader, dataStream, CsvInput.this.delimiter, CsvInput.this.relationshipIds, decorator);
                    }
                };
            }
        };
    }

    @Override
    public IdMapping idMapping() {
        return this.idMapping;
    }
}

