/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Collection;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public class InputRelationship
extends InputEntity {
    private final long id;
    private final Object startNode;
    private final Object endNode;
    private String type;
    private final Integer typeId;

    public InputRelationship(long id, Object[] properties, Long firstPropertyId, Object startNode, Object endNode, String type, Integer typeId) {
        super(properties, firstPropertyId);
        this.id = id;
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
        this.typeId = typeId;
    }

    public long id() {
        return this.id;
    }

    public Object startNode() {
        return this.startNode;
    }

    public Object endNode() {
        return this.endNode;
    }

    public boolean isLoop() {
        return this.startNode.equals(this.endNode);
    }

    public Direction startDirection() {
        return this.isLoop() ? Direction.BOTH : Direction.OUTGOING;
    }

    public String type() {
        return this.type;
    }

    public boolean hasTypeId() {
        return this.typeId != null;
    }

    public int typeId() {
        return this.typeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        super.toStringFields(fields);
        fields.add(Pair.of("startNode", this.startNode));
        fields.add(Pair.of("endNode", this.endNode));
        if (this.hasTypeId()) {
            fields.add(Pair.of("typeId", this.typeId));
        } else {
            fields.add(Pair.of("type", this.type));
        }
    }
}

