/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping;

import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;

public class IdMappers {
    public static IdMapper actual() {
        return new ActualIdMapper();
    }

    public static IdMapper strings(LongArrayFactory cacheFactory) {
        return new EncodingIdMapper(cacheFactory, new StringEncoder(), new Radix.String());
    }

    public static IdMapper longs(LongArrayFactory cacheFactory) {
        return new EncodingIdMapper(cacheFactory, new LongEncoder(), new Radix.Long());
    }

    private static class ActualIdMapper
    implements IdMapper {
        private ActualIdMapper() {
        }

        @Override
        public void put(Object inputId, long actualId) {
        }

        @Override
        public boolean needsPreparation() {
            return false;
        }

        @Override
        public void prepare(Iterable<Object> nodeData) {
        }

        @Override
        public long get(Object inputId) {
            return (Long)inputId;
        }

        @Override
        public void visitMemoryStats(MemoryStatsVisitor visitor) {
        }
    }
}

