/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;

public class HeapLongArray
implements LongArray {
    private final long[][] shards;
    private final long length;
    private final long defaultValue;
    private long highestSetIndex = -1L;
    private long size;

    public HeapLongArray(long length, long defaultValue) {
        this.length = length;
        this.defaultValue = defaultValue;
        int numShards = (int)((length - 1L) / Integer.MAX_VALUE) + 1;
        this.shards = new long[numShards][];
        for (int i = 0; i < numShards - 1; ++i) {
            this.shards[i] = this.newShard(Integer.MAX_VALUE);
        }
        this.shards[numShards - 1] = this.newShard((int)(length % Integer.MAX_VALUE));
    }

    private long[] newShard(int length) {
        long[] shard = new long[length];
        if (this.defaultValue != 0L) {
            Arrays.fill(shard, this.defaultValue);
        }
        return shard;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long get(long index) {
        return this.shard(index)[this.arrayIndex(index)];
    }

    @Override
    public void set(long index, long value) {
        int arrayIndex;
        long[] shard = this.shard(index);
        if (shard[arrayIndex = this.arrayIndex(index)] == this.defaultValue) {
            ++this.size;
        }
        shard[arrayIndex] = value;
        if (index > this.highestSetIndex) {
            this.highestSetIndex = index;
        }
    }

    @Override
    public long highestSetIndex() {
        return this.highestSetIndex;
    }

    @Override
    public long size() {
        return this.size;
    }

    private long[] shard(long index) {
        return this.shards[this.shardIndex(index)];
    }

    @Override
    public void clear() {
        for (long[] shard : this.shards) {
            Arrays.fill(shard, this.defaultValue);
        }
        this.highestSetIndex = -1L;
        this.size = 0L;
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            long fromValue = this.get(fromIndex + (long)i);
            long toValue = this.get(toIndex + (long)i);
            this.set(fromIndex + (long)i, toValue);
            this.set(toIndex + (long)i, fromValue);
        }
    }

    private int arrayIndex(long index) {
        return index < Integer.MAX_VALUE ? (int)index : (int)(index % Integer.MAX_VALUE);
    }

    private int shardIndex(long index) {
        return index < Integer.MAX_VALUE ? 0 : (int)(index / Integer.MAX_VALUE);
    }

    @Override
    public void visitMemoryStats(MemoryStatsVisitor visitor) {
        visitor.heapUsage(this.length * 8L);
    }
}

