/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;

public class DynamicLongArray
implements LongArray {
    private final LongArrayFactory factory;
    private final long chunkSize;
    private LongArray[] chunks = new LongArray[0];
    private final long defaultValue;

    public DynamicLongArray(LongArrayFactory factory, long chunkSize, long defaultValue) {
        this.factory = factory;
        this.chunkSize = chunkSize;
        this.defaultValue = defaultValue;
    }

    @Override
    public long length() {
        return (long)this.chunks.length * this.chunkSize;
    }

    @Override
    public long get(long index) {
        int chunkIndex = this.chunkIndex(index);
        return chunkIndex < this.chunks.length ? this.chunks[chunkIndex].get(this.index(index)) : this.defaultValue;
    }

    @Override
    public void set(long index, long value) {
        while (index >= this.length()) {
            this.addChunk();
        }
        this.chunk(index).set(this.index(index), value);
    }

    @Override
    public long highestSetIndex() {
        for (int i = this.chunks.length - 1; i >= 0; --i) {
            LongArray chunk = this.chunks[i];
            long highestSetInChunk = chunk.highestSetIndex();
            if (highestSetInChunk <= -1L) continue;
            return (long)i * this.chunkSize + highestSetInChunk;
        }
        return -1L;
    }

    @Override
    public long size() {
        long size = 0L;
        for (int i = 0; i < this.chunks.length; ++i) {
            size += this.chunks[i].size();
        }
        return size;
    }

    private long index(long index) {
        return index % this.chunkSize;
    }

    private LongArray chunk(long index) {
        return this.chunks[this.chunkIndex(index)];
    }

    private int chunkIndex(long index) {
        return (int)(index / this.chunkSize);
    }

    private void addChunk() {
        LongArray newLongArray;
        this.chunks = Arrays.copyOf(this.chunks, this.chunks.length + 1);
        this.chunks[this.chunks.length - 1] = newLongArray = this.factory.newLongArray(this.chunkSize, this.defaultValue);
    }

    @Override
    public void clear() {
        for (LongArray chunk : this.chunks) {
            chunk.clear();
        }
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            long intermediary = this.get(fromIndex + (long)i);
            this.set(fromIndex + (long)i, this.get(toIndex + (long)i));
            this.set(toIndex + (long)i, intermediary);
        }
    }

    @Override
    public void visitMemoryStats(MemoryStatsVisitor visitor) {
        for (LongArray chunk : this.chunks) {
            chunk.visitMemoryStats(visitor);
        }
    }
}

