/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.unsafe.impl.batchimport.RecordBatch;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public final class NodeEncoderStep
extends ExecutorServiceStep<List<InputNode>> {
    private final IdMapper idMapper;
    private final IdGenerator idGenerator;
    private final NodeStore nodeStore;
    private final BatchingTokenRepository<?> propertyKeyHolder;
    private final BatchingTokenRepository<?> labelHolder;
    private final PropertyCreator propertyCreator;
    private final Iterable<Object> allIds;

    public NodeEncoderStep(StageControl control, String name, int workAheadSize, int numberOfExecutors, IdMapper idMapper, IdGenerator idGenerator, BatchingTokenRepository<?> propertyKeyHolder, BatchingTokenRepository<?> labelHolder, NodeStore nodeStore, PropertyStore propertyStore, Iterable<Object> allIds) {
        super(control, name, workAheadSize, numberOfExecutors);
        this.idMapper = idMapper;
        this.idGenerator = idGenerator;
        this.nodeStore = nodeStore;
        this.propertyKeyHolder = propertyKeyHolder;
        this.labelHolder = labelHolder;
        this.allIds = allIds;
        this.propertyCreator = new PropertyCreator(propertyStore, null);
    }

    @Override
    protected Object process(long ticket, List<InputNode> batch) {
        BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
        ArrayList<NodeRecord> nodeRecords = new ArrayList<NodeRecord>(batch.size());
        for (InputNode batchNode : batch) {
            long nodeId = this.idGenerator.generate(batchNode.id());
            this.idMapper.put(batchNode.id(), nodeId);
            NodeRecord nodeRecord = new NodeRecord(nodeId, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            nodeRecord.setInUse(true);
            nodeRecords.add(nodeRecord);
            long nextProp = batchNode.hasFirstPropertyId() ? batchNode.firstPropertyId() : this.propertyCreator.createPropertyChain(nodeRecord, Utils.propertyKeysAndValues(batchNode.properties(), this.propertyKeyHolder, this.propertyCreator), propertyRecords);
            nodeRecord.setNextProp(nextProp);
            if (batchNode.hasLabelField()) {
                nodeRecord.setLabelField(batchNode.labelField(), Collections.emptyList());
                continue;
            }
            long[] labels = this.labelHolder.getOrCreateIds(batchNode.labels());
            InlineNodeLabels.put(nodeRecord, labels, null, this.nodeStore.getDynamicLabelStore());
        }
        return new RecordBatch(nodeRecords, propertyRecords.records());
    }

    @Override
    protected void done() {
        this.idMapper.prepare(this.allIds);
        super.done();
    }
}

