/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.NodeStoreProcessorStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class NodeCountsStep
extends NodeStoreProcessorStep {
    private final long[] labelCounts;
    private final NodeLabelsCache cache;
    private final CountsTracker countsTracker;
    private final int anyLabel;

    public NodeCountsStep(StageControl control, int batchSize, NodeStore nodeStore, NodeLabelsCache cache, int highLabelId, CountsTracker countsTracker) {
        super(control, "NODE COUNTS", batchSize, nodeStore);
        this.cache = cache;
        this.anyLabel = highLabelId;
        this.countsTracker = countsTracker;
        this.labelCounts = new long[highLabelId + 1];
    }

    @Override
    protected boolean process(NodeRecord node) {
        long[] labels = NodeLabelsField.get(node, this.nodeStore);
        if (labels.length > 0) {
            for (long labelId : labels) {
                int n = (int)labelId;
                this.labelCounts[n] = this.labelCounts[n] + 1L;
            }
            this.cache.put(node.getId(), labels);
        }
        int n = this.anyLabel;
        this.labelCounts[n] = this.labelCounts[n] + 1L;
        return false;
    }

    @Override
    protected void done() {
        for (int i = 0; i < this.labelCounts.length; ++i) {
            this.countsTracker.incrementNodeCount(i == this.anyLabel ? -1 : i, this.labelCounts[i]);
        }
    }
}

