/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.unsafe.impl.batchimport.RecordBatch;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class EntityStoreUpdaterStep<T extends PrimitiveRecord>
extends ExecutorServiceStep<RecordBatch<T>> {
    private final AbstractRecordStore<T> entityStore;
    private final PropertyStore propertyStore;
    private final IoMonitor monitor;

    EntityStoreUpdaterStep(StageControl control, String name, AbstractRecordStore<T> entityStore, PropertyStore propertyStore, IoMonitor monitor) {
        super(control, name, 1, 1);
        this.entityStore = entityStore;
        this.propertyStore = propertyStore;
        this.monitor = monitor;
        this.monitor.reset();
    }

    @Override
    protected Object process(long ticket, RecordBatch<T> batch) {
        for (PrimitiveRecord entityRecord : batch.getEntityRecords()) {
            this.entityStore.setHighestPossibleIdInUse(entityRecord.getId());
            this.entityStore.updateRecord(entityRecord);
        }
        for (PropertyRecord propertyRecord : batch.getPropertyRecords()) {
            this.propertyStore.updateRecord(propertyRecord);
        }
        return null;
    }

    @Override
    protected void addStatsProviders(Collection<StatsProvider> providers) {
        super.addStatsProviders(providers);
        providers.add(this.monitor);
    }

    @Override
    protected void done() {
        this.monitor.stop();
    }
}

